/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import utils.files.FileUtil;
import utils.progtools.streams.BitInputStream;
import utils.progtools.streams.BitOutputStream;
import utils.progtools.streams.LittleEndianDataInputStream;
import utils.progtools.streams.LittleEndianDataOutputStream;
import utils.swing.images.ImageHelper;

public class ICOReader {
    public static Header readImageHeader(DataInputStream din) throws IOException {
        Header header = new Header();
        header.width = din.read();
        header.height = din.read();
        if (header.width == 0) {
            header.width = 256;
        }
        if (header.height == 0) {
            header.height = 256;
        }
        header.bColorCount = din.read();
        din.read();
        header.colourPlanes = Short.reverseBytes(din.readShort());
        header.bpp = Short.reverseBytes(din.readShort());
        header.dataLength = Integer.reverseBytes(din.readInt());
        header.offset = Integer.reverseBytes(din.readInt());
        return header;
    }

    public static ImageList readIcoFile(File icoFile) throws IOException {
        return ICOReader.readIcoFile(FileUtil.readFile((File)icoFile));
    }

    public static ImageList readIcoFile(byte[] source) throws IOException {
        ImageList result = new ImageList();
        DataInputStream din = new DataInputStream(new ByteArrayInputStream(source));
        din.readShort();
        din.readShort();
        int imageCount = Short.reverseBytes(din.readShort());
        Header[] headers = new Header[imageCount];
        for (int i = 0; i < imageCount; ++i) {
            headers[i] = ICOReader.readImageHeader(din);
        }
        din.close();
        boolean image = false;
        for (Header header : headers) {
            byte[] data = new byte[header.dataLength];
            System.arraycopy(source, header.offset, data, 0, data.length);
            BufferedImage readImage = ICOReader.loadAsBMP(data, header.width, header.height);
            if (header.width == 16) {
                result.image16 = readImage;
                continue;
            }
            if (header.width == 24) {
                result.image24 = readImage;
                continue;
            }
            if (header.width == 32) {
                result.image32 = readImage;
                continue;
            }
            if (header.width != 48) continue;
            result.image48 = readImage;
        }
        return result;
    }

    private static boolean isPNG(byte[] data) {
        byte[] header = new byte[]{-119, 80, 78, 71, 13, 10};
        for (int i = 0; i < header.length; ++i) {
            if (data[i] == header[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] create16Icon_16bit(File image16, File image16_16bit) throws IOException {
        if (image16 == null && image16_16bit == null) {
            return new byte[0];
        }
        File file = image16;
        if (image16_16bit != null) {
            file = image16_16bit;
        }
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, 16, 16);
        return ICOReader.createBMP(resizedImage, 16);
    }

    private static void writeImageHeader(DataOutputStream fout, int offset, byte[] iconData, int size, int bpp) throws IOException {
        if (iconData.length == 0) {
            return;
        }
        int width = size;
        int height = size;
        boolean colourPlanes = true;
        if (width == 256) {
            fout.write(0);
        } else {
            fout.write(width);
        }
        if (height == 256) {
            fout.write(0);
        } else {
            fout.write(height);
        }
        fout.write(0);
        fout.write(0);
        fout.writeShort(Short.reverseBytes((short)(colourPlanes ? 1 : 0)));
        fout.writeShort(Short.reverseBytes((short)bpp));
        fout.writeInt(Integer.reverseBytes(iconData.length));
        fout.writeInt(Integer.reverseBytes(offset));
    }

    private static byte[] create16Icon(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, 16, 16);
        return ICOReader.createBMP(resizedImage, 32);
    }

    private static BufferedImage loadAsBMP(byte[] data, int width, int height) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(bin);
        BufferedImage image = new BufferedImage(width, height, 2);
        BMPHeader header = ICOReader.readBMPHeader(image, in);
        ICOReader.readXORImage(image, in, header);
        BitInputStream bitIn = new BitInputStream(bin);
        ICOReader.readANDImage(image, bitIn, header.requiredDepth);
        return image;
    }

    private static byte[] createBMP(BufferedImage resizedImage, int requiredDepth) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        LittleEndianDataOutputStream out = new LittleEndianDataOutputStream(bout);
        ICOReader.writeBMPHeader(resizedImage, out, requiredDepth);
        ICOReader.writeXORImage(resizedImage, out, requiredDepth);
        out.close();
        BitOutputStream bitOut = new BitOutputStream(bout);
        ICOReader.writeANDImage(resizedImage, bitOut, requiredDepth);
        return bout.toByteArray();
    }

    private static int rgbTo55516Bit(int r, int g, int b) {
        return r >> 3 << 10 | g >> 3 << 5 | b >> 3;
    }

    private static int convert55516BitToRGB(int fff) {
        int r = 0x1F & fff >> 10;
        int g = 0x1F & fff >> 5;
        int b = 0x1F & fff;
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    private static void readXORImage(BufferedImage resizedImage, LittleEndianDataInputStream in, BMPHeader header) throws IOException {
        BitInputStream bitInputStream = new BitInputStream(in);
        int requiredDepth = header.requiredDepth;
        for (int y = resizedImage.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < resizedImage.getWidth(); ++x) {
                int a;
                if (requiredDepth == 32 || requiredDepth == 24) {
                    byte b = in.readByte();
                    byte g = in.readByte();
                    byte r = in.readByte();
                    int a2 = 255;
                    if (requiredDepth == 32) {
                        a2 = in.readByte();
                    }
                    int rgb = a2;
                    rgb = (rgb << 8) + r;
                    rgb = (rgb << 8) + g;
                    rgb = (rgb << 8) + b;
                    resizedImage.setRGB(x, y, rgb);
                    continue;
                }
                if (requiredDepth == 16) {
                    short shortResult = in.readShort();
                    int rgb = ICOReader.convert55516BitToRGB(shortResult);
                    resizedImage.setRGB(x, y, rgb);
                    continue;
                }
                if (requiredDepth > 8) continue;
                int index = requiredDepth == 8 ? in.read() : bitInputStream.readBits(requiredDepth);
                int b = header.colours[index].b;
                int g = header.colours[index].g;
                int r = header.colours[index].r;
                int rgb = a = 255;
                rgb = (rgb << 8) + r;
                rgb = (rgb << 8) + g;
                rgb = (rgb << 8) + b;
                resizedImage.setRGB(x, y, rgb);
            }
        }
    }

    private static void writeXORImage(BufferedImage resizedImage, LittleEndianDataOutputStream out, int requiredDepth) throws IOException {
        int writtenBytes = 0;
        for (int y = resizedImage.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < resizedImage.getWidth(); ++x) {
                int pixel = resizedImage.getRGB(x, y);
                int alpha = pixel >> 24;
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                if (requiredDepth == 32 || requiredDepth == 24) {
                    out.writeByte(b);
                    out.writeByte(g);
                    out.writeByte(r);
                    if (requiredDepth != 32) continue;
                    out.writeByte(alpha);
                    continue;
                }
                if (requiredDepth != 16) continue;
                int shortResult = ICOReader.rgbTo55516Bit(r, g, b);
                out.writeShort(shortResult);
                writtenBytes += 2;
            }
        }
        while (writtenBytes % 4 != 0) {
            out.writeByte(0);
            ++writtenBytes;
        }
    }

    private static void readANDImage(BufferedImage resizedImage, BitInputStream out, int requiredDepth) throws IOException {
        if (requiredDepth == 32) {
            return;
        }
        for (int y = resizedImage.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < resizedImage.getWidth(); ++x) {
                int alpha = 255;
                if (out.readBits(1) == 1) {
                    alpha = 0;
                }
                int pixel = resizedImage.getRGB(x, y);
                pixel &= 0xFFFFFF;
                pixel |= alpha << 24;
            }
        }
    }

    private static void writeANDImage(BufferedImage resizedImage, BitOutputStream out, int requiredDepth) throws IOException {
        if (requiredDepth == 32) {
            return;
        }
        int bitCount = 0;
        for (int y = resizedImage.getHeight() - 1; y >= 0; --y) {
            for (int x = 0; x < resizedImage.getWidth(); ++x) {
                int pixel = resizedImage.getRGB(x, y);
                int alpha = pixel >> 24;
                if (alpha == 0) {
                    out.write(1, 1);
                } else {
                    out.write(1, 0);
                }
                ++bitCount;
            }
        }
        while (bitCount % 32 != 0) {
            out.write(1, 0);
            ++bitCount;
        }
    }

    private static BMPHeader readBMPHeader(BufferedImage image, LittleEndianDataInputStream in) throws IOException {
        BMPHeader header = new BMPHeader();
        header.structSize = in.readInt();
        header.width = in.readInt();
        header.height = in.readInt();
        header.planes = in.readShort();
        header.requiredDepth = in.readShort();
        header.compression = in.readInt();
        header.biSizeImage = in.readInt();
        header.xppm = in.readInt();
        header.yppm = in.readInt();
        header.biClrUsed = in.readInt();
        header.biClrImportant = in.readInt();
        if (header.requiredDepth <= 8) {
            header.colours = new RGBQuad[header.biClrUsed];
            for (int i = 0; i < header.colours.length; ++i) {
                header.colours[i] = new RGBQuad();
                header.colours[i].b = in.read();
                header.colours[i].g = in.read();
                header.colours[i].r = in.read();
                in.read();
            }
        }
        return header;
    }

    private static void writeBMPHeader(BufferedImage resizedImage, LittleEndianDataOutputStream out, int requiredDepth) throws IOException {
        out.writeInt(40);
        out.writeInt(resizedImage.getWidth());
        out.writeInt(resizedImage.getHeight() * 2);
        out.writeShort(1);
        out.writeShort(requiredDepth);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
    }

    private static byte[] create24Icon(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, 24, 24);
        return ICOReader.createBMP(resizedImage, 32);
    }

    private static byte[] create32Icon(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, 32, 32);
        return ICOReader.createBMP(resizedImage, 32);
    }

    private static byte[] create48Icon(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedImage sourceImage = ImageIO.read(file);
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, 48, 48);
        return ICOReader.createBMP(resizedImage, 32);
    }

    private static BufferedImage resizeImage(Image originalImage, int targetWidth, int targetHeight) {
        return ImageHelper.scaleDownToFitInside((BufferedImage)ImageHelper.toBufferedImageARGB((Image)originalImage), (int)targetWidth, (int)targetHeight, (boolean)true);
    }

    private static byte[] create256Icon(File file) throws IOException {
        if (file == null) {
            return new byte[0];
        }
        BufferedImage sourceImage = ImageIO.read(file);
        return ICOReader.getResizedImageData(sourceImage, 256);
    }

    private static byte[] getResizedImageData(Image sourceImage, int squareSize) throws IOException {
        BufferedImage resizedImage = ICOReader.resizeImage(sourceImage, squareSize, squareSize);
        ByteArrayOutputStream imageData = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)resizedImage, "png", imageData);
        imageData.close();
        return imageData.toByteArray();
    }

    static class BMPHeader {
        int structSize;
        int width;
        int height;
        int planes;
        int requiredDepth;
        int compression;
        int biSizeImage;
        int xppm;
        int yppm;
        int biClrUsed;
        int biClrImportant;
        RGBQuad[] colours;

        BMPHeader() {
        }
    }

    static class RGBQuad {
        int r;
        int g;
        int b;

        RGBQuad() {
        }
    }

    static class Header {
        int width;
        int height;
        int colourPlanes;
        int bpp;
        int dataLength;
        int offset;
        public int bColorCount;

        Header() {
        }

        public String toString() {
            return "ICOHeader " + this.width + " x " + this.height + " (" + this.colourPlanes + "," + this.bpp + ") length=" + this.dataLength;
        }
    }

    public static class ImageList {
        public BufferedImage image16;
        public BufferedImage image24;
        public BufferedImage image32;
        public BufferedImage image48;
        public BufferedImage image256;
        public BufferedImage image16_16bit;
        public BufferedImage image24_16bit;
        public BufferedImage image32_16bit;
        public BufferedImage image48_16bit;
    }
}

