/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import utils.swing.WeakReferenceTimer;

public class FadeIcon
implements Icon,
ActionListener {
    private int numberOfSteps = 30;
    private Icon icon;
    private Component c;
    private boolean fadeOut = true;
    private int numberOfCylces = 0;
    private int step = 0;
    private int cycle = 0;
    private boolean animating = true;
    private WeakReferenceTimer weakReferenceTimer;
    private FadeListener listener;

    public void setFadeListener(FadeListener listener) {
        this.listener = listener;
    }

    public FadeIcon(Icon parent) {
        this(parent, 30, 25, 0, true);
    }

    public FadeIcon(Icon parent, int steps, int stepsPerSecond, int numberOfCylces, boolean start) {
        this.icon = parent;
        this.numberOfSteps = steps;
        this.numberOfCylces = numberOfCylces;
        this.weakReferenceTimer = new WeakReferenceTimer(this, 1000 / stepsPerSecond);
        if (start) {
            this.weakReferenceTimer.start();
        }
    }

    public void setUpdateComponent(Component c) {
        this.c = c;
    }

    public void restart() {
        this.fadeOut = true;
        this.cycle = 0;
        this.animating = true;
        this.weakReferenceTimer.restart();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g1, int x, int y) {
        Graphics2D g2d = (Graphics2D)g1;
        if (this.c == null) {
            this.c = c;
        }
        float percent = 1.0f - (float)this.step / (float)this.numberOfSteps;
        Composite comp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, percent));
        try {
            this.icon.paintIcon(null, g1, x, y);
        }
        finally {
            g2d.setComposite(comp);
        }
        if (this.animating && percent == 1.0f && this.numberOfCylces == this.cycle) {
            this.weakReferenceTimer.stop();
            this.animating = false;
            if (this.listener != null) {
                this.listener.animationEnded();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.step = this.fadeOut ? ++this.step : --this.step;
        if (this.step == 0) {
            this.cycle = Math.max(this.cycle + 1, 1);
        }
        if (this.step == this.numberOfSteps - 1 || this.step == 0) {
            boolean bl = this.fadeOut = !this.fadeOut;
        }
        if (this.c != null) {
            this.c.repaint();
        }
    }

    public static interface FadeListener {
        public void animationEnded();
    }
}

