/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CombinedIcon
implements Icon {
    Icon[] icons;
    int[] xs;
    int[] ys;

    public CombinedIcon(Icon[] icons, int[] xoffs, int[] yoffs) {
        this.icons = icons;
        this.xs = xoffs;
        this.ys = yoffs;
    }

    @Override
    public int getIconHeight() {
        int ymin = Integer.MAX_VALUE;
        int ymax = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            ymin = Math.min(ymin, this.ys[i]);
            ymax = Math.max(ymax, this.ys[i] + this.icons[i].getIconHeight());
        }
        return ymax - ymin;
    }

    @Override
    public int getIconWidth() {
        int xmin = Integer.MAX_VALUE;
        int xmax = 0;
        for (int i = 0; i < this.icons.length; ++i) {
            xmin = Math.min(xmin, this.xs[i]);
            xmax = Math.max(xmax, this.xs[i] + this.icons[i].getIconWidth());
        }
        return xmax - xmin;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int i;
        int ymin = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < this.icons.length; ++i2) {
            ymin = Math.min(ymin, this.ys[i2]);
        }
        int xmin = Integer.MAX_VALUE;
        for (i = 0; i < this.icons.length; ++i) {
            xmin = Math.min(xmin, this.xs[i]);
        }
        for (i = 0; i < this.icons.length; ++i) {
            this.icons[i].paintIcon(c, g, x - xmin + this.xs[i], y - ymin + this.ys[i]);
        }
    }
}

