/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.ui;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.swing.SwingStyleInterface;
import utils.swing.SwingUtil;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.TextAreaField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.cui.ui.ConfigUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class TextAreaConfigUI
extends ConfigUI
implements FocusListener {
    private String originalRowsValue = null;
    private JLabel defaultValueLabel;
    private JLabel exampleValueLabel;
    private JLabel rowsLabel;
    private JTextField rowsField;
    private JTextField valueField;
    private JTextField exampleField;
    private JCheckBox requiredBox;

    public TextAreaConfigUI(ResourceBundle bundle, SwingStyleInterface style, AbstractField.ChangeListener listener) {
        super(bundle, style, listener);
    }

    private void updateEnabled() {
    }

    @Override
    public void initUI() {
        this.requiredBox = new JCheckBox(this.bundle.getString("CUI_VALIDATION_REQUIRED"));
        this.requiredBox.addActionListener(this.actionChangeListener);
        this.valueField = new JTextField();
        this.valueField.addKeyListener(this.keyChangeListener);
        this.exampleField = new JTextField();
        this.exampleField.addKeyListener(this.keyChangeListener);
        TextField textField = new TextField("", null, 1);
        textField.setLengthConstraints(2, 0);
        this.rowsField = (JTextField)textField.getComponent();
        this.rowsField.setText("5");
        this.rowsField.addFocusListener(this);
        this.rowsField.addKeyListener(this.keyChangeListener);
        this.defaultValueLabel = new JLabel(this.bundle.getString("CUI_TEXT_DEFAULT"));
        this.exampleValueLabel = new JLabel(this.bundle.getString("CUI_TEXT_EXAMPLE"));
        this.rowsLabel = new JLabel(this.bundle.getString("CUI_TEXTAREA_ROWS"));
        SwingUtil.setWidth((JComponent)this.valueField, (int)SimpleHelpLookAndFeel.scale((int)350));
        SwingUtil.setWidth((JComponent)this.exampleField, (int)SimpleHelpLookAndFeel.scale((int)350));
        SwingUtil.setWidth((JComponent)this.rowsField, (int)SimpleHelpLookAndFeel.scale((int)30));
        int Y = 0;
        int X = 0;
        this.rootComponent.add((Component)this.requiredBox, 1, Y, 2, 1, 0, 1, 17, 0);
        X = 0;
        this.rootComponent.add((Component)this.rowsLabel, X++, ++Y, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.rowsField, X++, Y, 1, 1, 1, 1, 17, 0);
        X = 0;
        this.rootComponent.add((Component)this.defaultValueLabel, X++, ++Y, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.valueField, X++, Y, 1, 1, 1, 1, 17, 0);
        X = 0;
        this.rootComponent.add((Component)this.exampleValueLabel, X++, ++Y, 1, 1, 0, 1, 13, 0);
        this.rootComponent.add((Component)this.exampleField, X++, Y, 1, 1, 1, 1, 17, 0);
        this.updateEnabled();
    }

    @Override
    public void loadConfigurationFrom(CUIField uiType) {
        TextAreaField textType = (TextAreaField)uiType;
        String defaultValue = textType.getDefaultValue();
        String exampleValue = textType.getExampleValue();
        int rowCount = textType.getRowCount();
        boolean required = textType.isRequired();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (exampleValue == null) {
            exampleValue = "";
        }
        this.valueField.setText(defaultValue);
        this.exampleField.setText(exampleValue);
        this.requiredBox.setSelected(required);
        this.rowsField.setText(rowCount + "");
    }

    @Override
    public void saveConfigurationTo(CUIField type) {
        TextAreaField textType = (TextAreaField)type;
        textType.clearValidators();
        if (this.valueField.getText().length() > 0) {
            textType.setDefaultValue(this.valueField.getText());
        }
        if (this.exampleField.getText().length() > 0) {
            textType.setExampleValue(this.exampleField.getText());
        }
        if (this.requiredBox.isSelected()) {
            textType.setRequired(this.requiredBox.isSelected());
        }
        if (this.rowsField.getText().length() > 0) {
            textType.setRowCount(Integer.parseInt(this.rowsField.getText()));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.originalRowsValue = this.rowsField.getText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.rowsField.getText().length() == 0) {
            this.rowsField.setText("" + this.originalRowsValue);
            this.rowsField.repaint();
        }
    }
}

