/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.reorderablepanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPanel;
import utils.swing.components.reorderablepanel.DragAndDropTransferHandler;
import utils.swing.components.reorderablepanel.ReorderablePanel;
import utils.swing.components.reorderablepanel.ReorderablePanelDropTargetListener;
import utils.swing.customlaf.ScaledInsets;

public class ReorderablePanelList
extends JPanel {
    private static DataFlavor dragAndDropPanelDataFlavor = null;
    public ReorderablePanelDropTargetListener demoPanelDropTargetListener;
    private List<ReorderablePanel> panels;

    public static DataFlavor getDragAndDropPanelDataFlavor() throws Exception {
        if (dragAndDropPanelDataFlavor == null) {
            dragAndDropPanelDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=" + ReorderablePanel.class.getCanonicalName());
        }
        return dragAndDropPanelDataFlavor;
    }

    public ReorderablePanelList() {
        this.setLayout(new GridBagLayout());
        this.panels = new ArrayList<ReorderablePanel>();
        this.setTransferHandler(new DragAndDropTransferHandler());
        this.demoPanelDropTargetListener = new ReorderablePanelDropTargetListener(this);
        this.setDropTarget(new DropTarget(this, this.demoPanelDropTargetListener));
    }

    public void setReorderNotifier(ReorderablePanelDropTargetListener.ReorderNotifier notifier) {
        this.demoPanelDropTargetListener.setReorderNotifier(notifier);
    }

    public List<ReorderablePanel> getReorderablePanels() {
        return this.panels;
    }

    public void relayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridx = 0;
        gbc.anchor = 11;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        int row = 0;
        this.removeAll();
        gbc.insets = new ScaledInsets(0, 0, 0, 0);
        for (ReorderablePanel p : this.panels) {
            gbc.gridy = row++;
            this.add((Component)p, gbc);
        }
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridy = row++;
        Component strut = Box.createVerticalStrut(1);
        this.add(strut, gbc);
        this.validate();
        this.repaint();
    }
}

