/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.reorderablepanel;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import javax.swing.JPanel;
import utils.swing.components.reorderablepanel.DragAndDropTransferHandler;
import utils.swing.components.reorderablepanel.DraggableMouseListener;
import utils.swing.components.reorderablepanel.ReorderablePanelDropTargetListener;
import utils.swing.components.reorderablepanel.ReorderablePanelList;

public abstract class ReorderablePanel
extends JPanel
implements Transferable,
Comparable<ReorderablePanel> {
    private int overrideY = -1;

    public ReorderablePanel() {
        this(true);
    }

    public ReorderablePanel(boolean allowReordering) {
        if (allowReordering) {
            DraggableMouseListener listener = new DraggableMouseListener();
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.setTransferHandler(new DragAndDropTransferHandler());
        }
    }

    public void setDragDropListener(ReorderablePanelDropTargetListener demoPanelDropTargetListener) {
        this.setDropTarget(new DropTarget(this, demoPanelDropTargetListener));
    }

    @Override
    public Object getTransferData(DataFlavor flavor) {
        DataFlavor thisFlavor = null;
        try {
            thisFlavor = ReorderablePanelList.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return null;
        }
        if (thisFlavor != null && flavor.equals(thisFlavor)) {
            return this;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{null};
        try {
            flavors[0] = ReorderablePanelList.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return null;
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = new DataFlavor[]{null};
        try {
            flavors[0] = ReorderablePanelList.getDragAndDropPanelDataFlavor();
        }
        catch (Exception ex) {
            System.err.println("Problem lazy loading: " + ex.getMessage());
            ex.printStackTrace(System.err);
            return false;
        }
        for (DataFlavor f : flavors) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ReorderablePanel o) {
        int y2;
        int y1 = this.overrideY >= 0 ? this.overrideY : this.getY();
        int n = y2 = o.overrideY >= 0 ? o.overrideY : o.getY();
        if (y1 == y2) {
            if (this.overrideY >= 0) {
                return -1;
            }
            if (o.overrideY >= 0) {
                return 1;
            }
        }
        return new Integer(y1).compareTo(new Integer(y2));
    }

    public void setOverrideY(int dropYLoc) {
        this.overrideY = Math.max(dropYLoc, 0);
    }
}

