/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.messagefields;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.swing.components.messagefields.MessageComponent;
import utils.swing.components.messagefields.MessageFieldHandler;

public class MessageTextPane
extends JTextPane
implements MessageComponent {
    private final MessageFieldHandler handler;
    private Color foregroundColor;

    public MessageTextPane(String message, MessageFieldHandler.FilterListener filterListener) {
        this.handler = new MessageFieldHandler((JTextComponent)this, message, filterListener);
        this.handler.init();
        this.setFont(UIManager.getFont("TextArea.font"));
    }

    protected Color getDefaultTextColor() {
        return UIManager.getColor("TextArea.foreground");
    }

    @Override
    public void setForeground(Color c) {
        this.foregroundColor = c;
        StyledDocument doc = this.getStyledDocument();
        if (doc == null) {
            return;
        }
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, c);
        doc.setParagraphAttributes(0, doc.getLength(), attrs, false);
        this.setDocument(doc);
        this.repaint();
    }

    @Override
    public Color getForeground() {
        return this.foregroundColor;
    }

    @Override
    public String getText() {
        if (this.handler.hasEnteredText()) {
            return super.getText();
        }
        return "";
    }

    @Override
    public void setText(String text) {
        if (text == null || text.length() == 0) {
            if (!this.hasFocus()) {
                this.handler.clear();
            } else {
                super.setText("");
            }
        } else {
            super.setText(text);
            this.handler.setDefaultColor();
        }
        this.repaint();
    }

    public boolean hasEnteredText() {
        return this.handler.hasEnteredText();
    }

    public void clear() {
        this.handler.clear();
        if (!this.hasFocus()) {
            super.setText(this.handler.getSearchText());
            this.handler.setGrayColor();
        } else {
            super.setText("");
        }
    }

    public void setMessageText(String message) {
        this.handler.setMessageText(message);
    }
}

