/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.slider;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import utils.swing.ExponentialSlider;
import utils.swing.components.FadePanel;

public class ComponentSliderPanel
extends FadePanel {
    private static int steps;
    private int currentStep = 0;
    long totalFadeMS = 3000L;
    private BufferedImage preSlideImage;
    private Dimension originalSize;
    private Point imageLocation;
    private boolean isFloating = false;
    private ExponentialSlider.ExponentialPainListener repaintListener = new ExponentialSlider.ExponentialPainListener(){

        public void paint(int index) {
            ComponentSliderPanel.this.currentStep = index;
            double percentageDone = ComponentSliderPanel.this.exponentialSlider.getPositionForStep(index) / 100.0;
            int x = (int)((double)((ComponentSliderPanel)ComponentSliderPanel.this).sourceLocation.x + percentageDone * (double)(((ComponentSliderPanel)ComponentSliderPanel.this).targetLocation.x - ((ComponentSliderPanel)ComponentSliderPanel.this).sourceLocation.x));
            int y = (int)((double)((ComponentSliderPanel)ComponentSliderPanel.this).sourceLocation.y + percentageDone * (double)(((ComponentSliderPanel)ComponentSliderPanel.this).targetLocation.y - ((ComponentSliderPanel)ComponentSliderPanel.this).sourceLocation.y));
            ComponentSliderPanel.this.imageLocation = new Point(x, y);
            ComponentSliderPanel.this.starttingToFloat();
            if (ComponentSliderPanel.this.exponentialSlider.isDone(index)) {
                ComponentSliderPanel.this.finishedFloat();
                ComponentSliderPanel.this.isFloating = false;
            } else {
                ComponentSliderPanel.this.isFloating = true;
            }
            ComponentSliderPanel.this.repaint();
        }
    };
    private Point sourceLocation;
    private ExponentialSlider exponentialSlider;
    private Point targetLocation;
    private BufferedImage targetSlideImage;

    public ComponentSliderPanel() {
        this(300L);
    }

    public ComponentSliderPanel(long totalFadeMS) {
        super((int)totalFadeMS);
        this.totalFadeMS = totalFadeMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isFloating) {
            Graphics2D g2d = (Graphics2D)g;
            float alpha = 1.0f / (float)steps * (float)this.currentStep;
            if (alpha < 0.0f) {
                alpha = 0.0f;
            }
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            Composite comp = g2d.getComposite();
            try {
                g2d.setColor(Color.WHITE);
                g2d.fillRect(this.imageLocation.x, this.imageLocation.y, this.originalSize.width, this.originalSize.height);
                g2d.drawImage((Image)this.preSlideImage, this.imageLocation.x, this.imageLocation.y, null);
                g2d.setComposite(AlphaComposite.getInstance(3, alpha));
                g.drawImage(this.targetSlideImage, this.imageLocation.x, this.imageLocation.y, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                g2d.setComposite(comp);
            }
        }
    }

    protected void starttingToFloat() {
    }

    protected void finishedFloat() {
    }

    public void preSlide(Component component, Component component2) {
        this.preSlideImage = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        Graphics2D g = this.preSlideImage.createGraphics();
        component.printAll(g);
        g.dispose();
        this.originalSize = component.getSize();
        this.sourceLocation = component.getLocation();
        component2.setSize(this.originalSize);
        component2.doLayout();
        this.targetSlideImage = new BufferedImage(component2.getWidth(), component2.getHeight(), 2);
        g = this.targetSlideImage.createGraphics();
        component2.printAll(g);
        g.dispose();
    }

    public void floatComponent(Component component, Point targetLocation) {
        this.targetLocation = targetLocation;
        steps = (int)(this.totalFadeMS / 25L);
        Graphics g = this.fadeToImage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(targetLocation.x, targetLocation.y, this.originalSize.width, this.originalSize.height);
        g.dispose();
        this.exponentialSlider = new ExponentialSlider(100.0, steps, 4.0, true);
        this.exponentialSlider.runAsSwingTimer(this.repaintListener, (int)(this.totalFadeMS / (long)steps));
    }
}

