/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components.animated.jlist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import utils.swing.WeakTimerListener;
import utils.swing.components.animated.jlist.Range1D;

public abstract class ReorderableJList
extends JList {
    private int currentlyDraggedIndex = -1;
    private static final List TEST_DATA = new ArrayList<Object>(Arrays.asList("Africa", "America", "Australia", "Antartica and other things", "Europe", "Asia", "Greenland", "China", "Timbuktu"));
    RepaintListener listener = new RepaintListener();
    private Timer timer = new Timer(33, new WeakTimerListener(this.listener, true));
    private ArrayList cellBounds;

    public ReorderableJList() {
        this.init();
    }

    public void dispose() {
        this.timer.stop();
        this.timer.removeActionListener(this.listener);
    }

    private void init() {
        GlobalListener listener = new GlobalListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.addComponentListener(listener);
        this.timer.start();
    }

    public ReorderableJList(AbstractListModel abstractListModel) {
        super(abstractListModel);
        this.init();
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private boolean recalculateCellBounds() {
        this.adjustCellBounds();
        return true;
    }

    public ArrayList computeActualCellBounds() {
        ArrayList<Rectangle> boundsList = new ArrayList<Rectangle>();
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            boundsList.add(this.getCellBounds(i, i));
        }
        return boundsList;
    }

    public boolean adjustCellBounds() {
        if (this.cellBounds == null) {
            return false;
        }
        boolean changed = false;
        ArrayList targetCellBounds = this.computeActualCellBounds();
        for (int i = 0; i < this.cellBounds.size(); ++i) {
            Rectangle currentBound = (Rectangle)this.cellBounds.get(i);
            Rectangle targetBound = (Rectangle)targetCellBounds.get(i);
            if (currentBound.y == targetBound.y) continue;
            int targetY = targetBound.y;
            int currentY = currentBound.y;
            currentY = Math.abs(targetY - currentY) == 1 ? targetY : (currentY < targetY ? (currentY += 2) : (currentY -= 2));
            currentBound.y = currentY;
            changed = true;
        }
        return changed;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics g2d = g;
        super.paintComponent(g);
        if (this.cellBounds != null && this.currentlyDraggedIndex != -1) {
            int dy;
            int dx;
            Rectangle currentBound;
            Rectangle actualBound;
            int i;
            Range1D range = new Range1D(0, this.getHeight());
            ArrayList targetCellBounds = this.computeActualCellBounds();
            ArrayList clonedBounds = (ArrayList)this.cellBounds.clone();
            for (i = 0; i < clonedBounds.size(); ++i) {
                if (i == this.currentlyDraggedIndex) continue;
                actualBound = (Rectangle)targetCellBounds.get(i);
                currentBound = (Rectangle)clonedBounds.get(i);
                dx = currentBound.x - actualBound.x;
                dy = currentBound.y - actualBound.y;
                if (dy < 0) {
                    g2d.copyArea(actualBound.x, actualBound.y, actualBound.width, actualBound.height, dx, dy);
                }
                range.markRange(currentBound.y, currentBound.y + currentBound.height);
            }
            for (i = clonedBounds.size() - 1; i >= 0; --i) {
                if (i == this.currentlyDraggedIndex) continue;
                actualBound = (Rectangle)targetCellBounds.get(i);
                currentBound = (Rectangle)clonedBounds.get(i);
                dx = currentBound.x - actualBound.x;
                dy = currentBound.y - actualBound.y;
                if (dy <= 0) continue;
                g2d.copyArea(actualBound.x, actualBound.y, actualBound.width, actualBound.height, dx, dy);
            }
            Rectangle actualBound2 = (Rectangle)targetCellBounds.get(this.currentlyDraggedIndex);
            range.markRange(actualBound2.y, actualBound2.y + actualBound2.height);
            g2d.setClip(actualBound2.x, actualBound2.y, actualBound2.width, actualBound2.height);
            super.paintComponent(g);
            g2d.translate(0, 0);
            g2d.setClip(null);
            Range1D.Range[] unmarkedRanges = range.getUnmarkedRanges();
            for (int i2 = 0; i2 < unmarkedRanges.length; ++i2) {
                Range1D.Range r = unmarkedRanges[i2];
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, r.start, this.getWidth(), r.end - r.start);
            }
        }
    }

    protected abstract void reorderElements(int var1, int var2);

    public static void main(String[] args) throws InterruptedException {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        AbstractListModel model = new AbstractListModel(){

            @Override
            public int getSize() {
                return TEST_DATA.size();
            }

            @Override
            public Object getElementAt(int index) {
                return TEST_DATA.get(index);
            }
        };
        ReorderableJList list = new ReorderableJList(model){

            @Override
            protected void reorderElements(int fromIndex, int toIndex) {
                Object o = TEST_DATA.remove(fromIndex);
                TEST_DATA.add(toIndex, o);
            }
        };
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, sel, focus);
                Color bg = c.getBackground();
                if (index % 2 == 0) {
                    int GRAY = 220;
                    c.setBackground(new Color((GRAY + bg.getRed() * 2) / 3, (GRAY + bg.getGreen() * 2) / 3, (GRAY + bg.getBlue() * 2) / 3));
                    ((JComponent)c).setOpaque(true);
                }
                return c;
            }
        });
        f.getContentPane().add(new JScrollPane(list));
        f.pack();
        f.setVisible(true);
    }

    class GlobalListener
    extends MouseAdapter
    implements MouseMotionListener,
    ComponentListener {
        private boolean dragActive;
        private Point origin;

        GlobalListener() {
        }

        private boolean sufficientMove(Point where) {
            int dy;
            int dx = Math.abs(this.origin.x - where.x);
            return Math.sqrt(dx * dx + (dy = Math.abs(this.origin.y - where.y)) * dy) > 5.0;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.origin = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.dragActive) {
                this.dragActive = false;
                ReorderableJList.this.currentlyDraggedIndex = -1;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int targetIndex;
            if (!this.dragActive && this.sufficientMove(e.getPoint())) {
                ReorderableJList.this.currentlyDraggedIndex = ReorderableJList.this.locationToIndex(this.origin);
                this.dragActive = true;
            }
            if (this.dragActive && (targetIndex = ReorderableJList.this.locationToIndex(e.getPoint())) != ReorderableJList.this.currentlyDraggedIndex) {
                if (ReorderableJList.this.cellBounds == null) {
                    ReorderableJList.this.cellBounds = ReorderableJList.this.computeActualCellBounds();
                }
                ReorderableJList.this.reorderElements(ReorderableJList.this.currentlyDraggedIndex, targetIndex);
                Object o = ReorderableJList.this.cellBounds.remove(ReorderableJList.this.currentlyDraggedIndex);
                ReorderableJList.this.cellBounds.add(targetIndex, o);
                ReorderableJList.this.currentlyDraggedIndex = targetIndex;
                ReorderableJList.this.revalidate();
                ReorderableJList.this.repaint();
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ReorderableJList.this.cellBounds = null;
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class RepaintListener
    implements ActionListener {
        private RepaintListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReorderableJList.this.isDisplayable() && ReorderableJList.this.recalculateCellBounds()) {
                ReorderableJList.this.repaint();
            }
        }
    }
}

