/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class SHSplitPane
extends JSplitPane {
    private boolean isLayedOut = false;
    private boolean hasProportionalLocation = false;
    private boolean hasPixelLocation = false;
    private double proportionalLocation;
    private int pixelLocation;
    private int dividerDragSize = 9;
    private int dividerDragOffset = 4;

    public SHSplitPane() {
        this(1);
    }

    public SHSplitPane(int orientation) {
        super(orientation);
        this.setContinuousLayout(true);
        this.setDividerSize(1);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.isLayedOut) {
            this.isLayedOut = true;
            if (this.hasProportionalLocation) {
                super.setDividerLocation(this.proportionalLocation);
            } else if (this.hasPixelLocation) {
                super.setDividerLocation(this.pixelLocation);
            }
            this.validate();
        }
        super.paintComponent(g);
    }

    @Override
    public int getDividerLocation() {
        if (!this.isLayedOut && !this.hasProportionalLocation) {
            return this.pixelLocation;
        }
        return super.getDividerLocation();
    }

    @Override
    public void setDividerLocation(double proportionalLocation) {
        if (!this.isLayedOut) {
            this.hasProportionalLocation = true;
            this.hasPixelLocation = false;
            this.proportionalLocation = proportionalLocation;
        } else {
            super.setDividerLocation(proportionalLocation);
        }
    }

    @Override
    public void setDividerLocation(int location) {
        if (!this.isLayedOut) {
            this.hasProportionalLocation = false;
            this.hasPixelLocation = true;
            this.pixelLocation = location;
        } else {
            super.setDividerLocation(location);
        }
    }

    public int getDividerDragSize() {
        return this.dividerDragSize;
    }

    public void setDividerDragSize(int dividerDragSize) {
        this.dividerDragSize = dividerDragSize;
        this.revalidate();
    }

    public int getDividerDragOffset() {
        return this.dividerDragOffset;
    }

    public void setDividerDragOffset(int dividerDragOffset) {
        this.dividerDragOffset = dividerDragOffset;
        this.revalidate();
    }

    @Override
    public void layout() {
        super.layout();
        BasicSplitPaneDivider divider = ((BasicSplitPaneUI)this.getUI()).getDivider();
        Rectangle bounds = divider.getBounds();
        if (this.orientation == 1) {
            bounds.x -= this.dividerDragOffset;
            bounds.width = this.dividerDragSize;
        } else {
            bounds.y -= this.dividerDragOffset;
            bounds.height = this.dividerDragSize;
        }
        divider.setBounds(bounds);
    }
}

