/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.components;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import utils.progtools.SingleThreadNotifier;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpFrame;

public class JEditableLabel
extends JPanel
implements FocusListener,
MouseListener,
KeyListener {
    private JLabel label;
    private JTextField field = new JTextField();
    private CardLayout cl;
    private boolean editing = false;
    private boolean isHTML;
    private ArrayList<EditListener> listeners = new ArrayList();
    private boolean isEditable = true;
    private Border emptyBorder;
    private Border textFieldBorder;
    private Border lineBorder;
    private Cursor iBeam = Cursor.getPredefinedCursor(2);
    private MouseListener cursorListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JEditableLabel.this.setCursor(JEditableLabel.this.iBeam);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (JEditableLabel.this.getBounds().contains(e.getPoint())) {
                return;
            }
            JEditableLabel.this.setCursor(null);
        }
    };
    private Icon rightIcon;

    public JEditableLabel(boolean wrapLabel) {
        this.label = wrapLabel ? new JWrapLabel() : new JLabel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (JEditableLabel.this.rightIcon != null) {
                    JEditableLabel.this.rightIcon.paintIcon(this, g, this.getWidth() - 10 - JEditableLabel.this.rightIcon.getIconWidth(), this.getHeight() / 2 - JEditableLabel.this.rightIcon.getIconHeight() / 2);
                }
            }
        };
        this.label.setCursor(Cursor.getPredefinedCursor(2));
        this.cl = new CardLayout();
        this.setLayout(this.cl);
        this.add((Component)this.label, "LABEL");
        this.add((Component)this.field, "FIELD");
        this.cl.show(this, "LABEL");
        this.field.addFocusListener(this);
        this.label.addMouseListener(this);
        this.field.addKeyListener(this);
        this.textFieldBorder = UIManager.getBorder("TextField.border");
        Insets insets = this.textFieldBorder.getBorderInsets(null);
        this.emptyBorder = SHBorderFactory.createEmptyBorder((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right);
        this.label.setBorder(this.emptyBorder);
        Border contractedEmptyBorder = SHBorderFactory.createEmptyBorder((int)(insets.top - 1), (int)(insets.left - 1), (int)(insets.bottom - 1), (int)(insets.right - 1));
        this.lineBorder = SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR), (Border)contractedEmptyBorder);
        this.addMouseListener(this.cursorListener);
    }

    public JEditableLabel(String text, boolean wrapLabel) {
        this(wrapLabel);
        this.setText(text);
    }

    public void setRightIcon(Icon rightIcon) {
        this.rightIcon = rightIcon;
        this.label.repaint();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.label != null) {
            this.label.setForeground(c);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.label != null) {
            this.label.setBackground(c);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
        if (this.field != null) {
            this.field.setFont(font);
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public void startEdit() {
        if (!this.isEditable) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JEditableLabel.this.doEdit();
            }
        });
    }

    protected void doEdit() {
        this.editing = true;
        String labelText = this.label.getText();
        this.isHTML = labelText.toLowerCase().startsWith("<html>");
        if (this.isHTML) {
            labelText = this.removeHTML(labelText);
        }
        this.field.setText(labelText);
        this.field.selectAll();
        this.cl.show(this, "FIELD");
        this.field.requestFocusInWindow();
        this.notifyListenersStart();
        this.repaint();
    }

    protected String removeHTML(String labelText) {
        return labelText.substring(6);
    }

    protected String addBackHTML(String labelText) {
        if (!labelText.toLowerCase().startsWith("<html>")) {
            return "<html>" + labelText;
        }
        return labelText;
    }

    public void endEdit(final boolean keepResult) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (JEditableLabel.this.editing) {
                    JEditableLabel.this.editing = false;
                    if (keepResult) {
                        if (JEditableLabel.this.isHTML) {
                            JEditableLabel.this.label.setText(JEditableLabel.this.addBackHTML(JEditableLabel.this.field.getText()));
                        } else {
                            JEditableLabel.this.label.setText(JEditableLabel.this.field.getText());
                        }
                        JEditableLabel.this.notifyListeners(JEditableLabel.this.field.getText());
                    }
                    JEditableLabel.this.cl.show(JEditableLabel.this, "LABEL");
                    JEditableLabel.this.repaint();
                }
            }
        };
        SingleThreadNotifier.runMe(r, 100, false, true);
    }

    private void notifyListeners(String newValue) {
        for (EditListener listener : this.listeners) {
            listener.editableLabelValueSet(newValue);
        }
    }

    private void notifyListenersStart() {
        for (EditListener listener : this.listeners) {
            listener.editableLabelStartEdit();
        }
    }

    public void addListener(EditListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.endEdit(true);
    }

    public static void main(String[] args) {
        SimpleHelpFrame testFrame = SimpleHelpFrame.getTestFrame();
        JEditableLabel label = new JEditableLabel(true);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.add(new JTextField("Test text field"));
        panel.add(new JPanel());
        panel.add(label);
        panel.add(new JPanel());
        panel.add(new JPanel());
        panel.add(new JButton("WOOT"));
        label.setText("<html>woot");
        testFrame.getContentPane().add(panel);
        testFrame.setVisible(true);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.startEdit();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.label.setBorder(this.lineBorder);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.label.setBorder(this.emptyBorder);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.endEdit(true);
        } else if (e.getKeyCode() == 27) {
            this.endEdit(false);
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void setIsEditable(boolean b) {
        this.isEditable = b;
        if (!b) {
            this.label.setCursor(null);
            this.label.removeMouseListener(this);
            this.removeMouseListener(this.cursorListener);
        } else {
            this.label.setCursor(Cursor.getPredefinedCursor(2));
            this.label.addMouseListener(this);
            this.addMouseListener(this.cursorListener);
        }
    }

    public void setHorizontalAlignment(int center) {
        this.label.setHorizontalAlignment(center);
    }

    public static interface EditListener {
        public void editableLabelStartEdit();

        public void editableLabelValueSet(String var1);
    }
}

