/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import utils.swing.MiniStatGraphPanel;

public class MiniLineStatGraph
implements MiniStatGraphPanel.MiniStatGraphInterface {
    public static final Color GREEN_VERY_DARK = new Color(51, 140, 34);
    public static final Color[] GREEN = new Color[]{new Color(160, 238, 160), new Color(74, 242, 74)};
    public static final Color[] BLUE = new Color[]{new Color(160, 181, 255), new Color(104, 128, 255)};
    Color bg;
    Color fillColor;
    Color lineColor;
    double max;

    public MiniLineStatGraph(Color bg, Color fillColor, Color lineColor, double max) {
        this.bg = bg;
        this.fillColor = fillColor;
        this.lineColor = lineColor;
        this.max = max;
    }

    public MiniLineStatGraph(Color bg, Color[] colors, double max) {
        this(bg, colors[0], colors[1], max);
    }

    @Override
    public void paint(Graphics g, double[] dat, int xoff, int yoff, int width, int height, boolean first) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g = g.create(xoff, yoff, width, height);
        if (first) {
            g.setColor(this.bg);
            g.fillRect(0, 0, width, height);
            g.setColor(this.fillColor);
        }
        GeneralPath topLine = new GeneralPath();
        Polygon pp = new Polygon();
        pp.addPoint(0, height);
        pp.addPoint(0, height);
        double wstep = (double)width / (double)(dat.length - 1);
        int prevx = 0;
        int prevy = 0;
        int startx = -1;
        for (int i = 0; i < dat.length; ++i) {
            prevx = (int)((double)i * wstep);
            prevy = height - (int)((double)height * (dat[i] / this.max));
            if (startx == -1) {
                startx = prevx;
            }
            pp.addPoint(prevx, prevy);
            if (i == 0) {
                topLine.moveTo(prevx, prevy);
                continue;
            }
            topLine.lineTo(prevx, prevy);
        }
        Graphics2D g2d2 = (Graphics2D)g;
        g2d2.setStroke(new BasicStroke(1.5f, 2, 2));
        if (pp.npoints > 0) {
            pp.addPoint(prevx, height);
            pp.addPoint(startx, height);
            g.setColor(this.fillColor);
            g.fillPolygon(pp);
        }
        g2d2.setColor(this.lineColor);
        g2d2.draw(topLine);
        g2d2.setStroke(new BasicStroke(1.0f, 0, 0));
        g.setColor(new Color(180, 180, 180, 255));
        g.drawRect(0, 0, width - 1, height - 1);
    }
}

