/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.util.ArrayList;

public class SearchTermSplitter {
    public static ArrayList<String> splitTermsSimple(String terms) {
        ArrayList<String> list = new ArrayList<String>();
        char[] cs = terms.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean inQuote = false;
        int quoteChar = 32;
        for (int n : cs) {
            if (!inQuote && n == 32) {
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (inQuote && n == quoteChar) {
                inQuote = false;
                if (sb.length() <= 0) continue;
                list.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (n == 39) {
                if (inQuote) continue;
                inQuote = true;
                quoteChar = 39;
                continue;
            }
            if (n == 34) {
                if (inQuote) continue;
                inQuote = true;
                quoteChar = 34;
                continue;
            }
            sb.append((char)n);
        }
        list.add(sb.toString());
        return list;
    }

    public ArrayList<String> splitTerms(String terms) {
        ArrayList<String> all = SearchTermSplitter.splitTermsSimple(terms);
        for (int i = 0; i < all.size(); ++i) {
            String term = all.get(i);
            term = term.trim();
            while (term.startsWith("\"") || term.startsWith("'") || term.startsWith("+")) {
                term = term.substring(1);
            }
            while (term.endsWith("\"") || term.endsWith("'")) {
                term = term.substring(0, term.length() - 1);
            }
            if ((term = term.trim()).length() != 0) continue;
            all.remove(i--);
        }
        return all;
    }

    private static void print(ArrayList<String> list) {
        System.out.println("List:");
        for (String item : list) {
            System.out.print("[" + item + "]");
        }
        System.out.println("");
    }

    public static void main(String[] args) throws Exception {
        SearchTermSplitter ws = new SearchTermSplitter();
        SearchTermSplitter.print(ws.splitTerms("one two three"));
        SearchTermSplitter.print(ws.splitTerms("one 'two two'"));
        SearchTermSplitter.print(ws.splitTerms("one \"two two\""));
        SearchTermSplitter.print(ws.splitTerms("one 'two two' 'three three'"));
        SearchTermSplitter.print(ws.splitTerms("one \"two two\" 'three three'"));
        SearchTermSplitter.print(ws.splitTerms("one \"two two 'two two'"));
        SearchTermSplitter.print(ws.splitTerms("one \"two two two two"));
        SearchTermSplitter.print(ws.splitTerms("one 'two two two two"));
        SearchTermSplitter.print(ws.splitTerms("mac '2k8"));
    }
}

