/*
 * Decompiled with CFR 0.152.
 */
package utils.string;

import java.util.HashMap;
import java.util.Locale;

public class Base32 {
    private static final Base32 INSTANCE = new Base32("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567");
    private String ALPHABET;
    private char[] DIGITS;
    private int MASK;
    private int SHIFT;
    private HashMap<Character, Integer> CHAR_MAP;
    static final String SEPARATOR = "-";

    static Base32 getInstance() {
        return INSTANCE;
    }

    protected Base32(String alphabet) {
        this.ALPHABET = alphabet;
        this.DIGITS = this.ALPHABET.toCharArray();
        this.MASK = this.DIGITS.length - 1;
        this.SHIFT = Integer.numberOfTrailingZeros(this.DIGITS.length);
        this.CHAR_MAP = new HashMap();
        for (int i = 0; i < this.DIGITS.length; ++i) {
            this.CHAR_MAP.put(Character.valueOf(this.DIGITS[i]), i);
        }
    }

    public static byte[] decode(String encoded) throws DecodingException {
        return Base32.getInstance().decodeInternal(encoded);
    }

    protected byte[] decodeInternal(String encoded) throws DecodingException {
        encoded = encoded.trim().replaceAll(SEPARATOR, "").replaceAll(" ", "");
        encoded = encoded.replaceFirst("[=]*$", "");
        if ((encoded = encoded.toUpperCase(Locale.US)).length() == 0) {
            return new byte[0];
        }
        int encodedLength = encoded.length();
        int outLength = encodedLength * this.SHIFT / 8;
        byte[] result = new byte[outLength];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (char c : encoded.toCharArray()) {
            if (!this.CHAR_MAP.containsKey(Character.valueOf(c))) {
                throw new DecodingException("Illegal character: " + c);
            }
            buffer <<= this.SHIFT;
            buffer |= this.CHAR_MAP.get(Character.valueOf(c)) & this.MASK;
            if ((bitsLeft += this.SHIFT) < 8) continue;
            result[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        return result;
    }

    public static String encode(byte[] data) {
        return Base32.getInstance().encodeInternal(data);
    }

    protected String encodeInternal(byte[] data) {
        if (data.length == 0) {
            return "";
        }
        if (data.length >= 0x10000000) {
            throw new IllegalArgumentException();
        }
        int outputLength = (data.length * 8 + this.SHIFT - 1) / this.SHIFT;
        StringBuilder result = new StringBuilder(outputLength);
        int buffer = data[0];
        int next = 1;
        for (int bitsLeft = 8; bitsLeft > 0 || next < data.length; bitsLeft -= this.SHIFT) {
            if (bitsLeft < this.SHIFT) {
                if (next < data.length) {
                    buffer <<= 8;
                    buffer |= data[next++] & 0xFF;
                    bitsLeft += 8;
                } else {
                    int pad = this.SHIFT - bitsLeft;
                    buffer <<= pad;
                    bitsLeft += pad;
                }
            }
            int index = this.MASK & buffer >> bitsLeft - this.SHIFT;
            result.append(this.DIGITS[index]);
        }
        return result.toString();
    }

    public static class DecodingException
    extends Exception {
        public DecodingException(String message) {
            super(message);
        }
    }
}

