/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.io.InputStream;
import utils.progtools.buffers.CircularByteBuffer;
import utils.progtools.buffers.CircularByteBufferOutputStream;

public class CircularStreamReader
extends Thread {
    private final CircularByteBufferOutputStream bufferStream;
    private final CircularByteBuffer buffer;
    private final InputStream in;
    private boolean die = false;

    public CircularStreamReader(InputStream in, int sizeInBytes) {
        super("CircularStreamReader");
        this.in = in;
        this.buffer = new CircularByteBuffer(sizeInBytes, false, false);
        this.bufferStream = new CircularByteBufferOutputStream(this.buffer);
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] popAll() {
        CircularByteBufferOutputStream circularByteBufferOutputStream = this.bufferStream;
        synchronized (circularByteBufferOutputStream) {
            int size = this.buffer.size();
            if (size == 0) {
                return new byte[0];
            }
            byte[] result = new byte[size];
            this.buffer.pop(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            int n = 0;
            byte[] buf = new byte[51200];
            while (!this.die && n != -1) {
                n = this.in.read(buf, 0, buf.length);
                if (n <= 0) continue;
                CircularByteBufferOutputStream circularByteBufferOutputStream = this.bufferStream;
                synchronized (circularByteBufferOutputStream) {
                    this.bufferStream.write(buf, 0, n);
                }
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void die() {
        this.die = true;
        try {
            this.in.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

