/*
 * Decompiled with CFR 0.152.
 */
package utils.ssl.letsencrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Map;
import utils.string.Base64URLEncoder;

public class LEUtils {
    public static String base64UrlEncode(byte[] v) {
        return Base64URLEncoder.byteArrayToBase64((byte[])v).replaceAll("=*$", "");
    }

    public static String signWith(String sig_alg, PrivateKey privateKey, Map<String, Object> header_, Map<String, Object> protected_, Map<String, Object> payload_) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        if (!"RS256".equals(sig_alg)) {
            throw new IllegalArgumentException("Unknown: " + sig_alg);
        }
        String sigAlg = "SHA256withRSA";
        header_.put("alg", sig_alg);
        String header = LEUtils.mapToJsonString(new StringBuilder(), header_).toString();
        System.out.println("\tHeader: " + header);
        System.out.println("\tProtected: " + LEUtils.mapToJsonString(new StringBuilder(), protected_));
        System.out.println("\tPayload: " + LEUtils.mapToJsonString(new StringBuilder(), payload_));
        String prot = LEUtils.base64UrlEncode(LEUtils.mapToJsonString(new StringBuilder(), protected_).toString().getBytes());
        String payload = LEUtils.base64UrlEncode(LEUtils.mapToJsonString(new StringBuilder(), payload_).toString().getBytes());
        Signature sig = Signature.getInstance(sigAlg);
        sig.initSign(privateKey);
        sig.update(prot.getBytes());
        sig.update(".".getBytes());
        sig.update(payload.getBytes());
        String signature = LEUtils.base64UrlEncode(sig.sign());
        String ret = "{\"header\": " + header + ", \"protected\": \"" + prot + "\", \"payload\": \"" + payload + "\", \"signature\": \"" + signature + "\"}";
        System.out.println(ret);
        return ret;
    }

    private static StringBuilder strToJsonString(StringBuilder out, String v) {
        return out.append('\"').append(v).append('\"');
    }

    private static StringBuilder mapToJsonString(StringBuilder out, Map<String, Object> m) {
        out.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            out.append('\"').append(e.getKey()).append("\": ");
            LEUtils.toJsonString(out, e.getValue());
        }
        return out.append("}");
    }

    private static StringBuilder arrToJsonString(StringBuilder out, String[] m) {
        out.append("[");
        boolean first = true;
        for (String e : m) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            LEUtils.toJsonString(out, e);
        }
        return out.append("]");
    }

    private static StringBuilder toJsonString(StringBuilder out, Object v) {
        if (v == null) {
            return out.append("null");
        }
        if (v instanceof String) {
            return LEUtils.strToJsonString(out, (String)v);
        }
        if (v instanceof String[]) {
            return LEUtils.arrToJsonString(out, (String[])v);
        }
        if (v instanceof Map) {
            return LEUtils.mapToJsonString(out, (Map)v);
        }
        if (v instanceof Boolean) {
            return out.append(((Boolean)v).toString());
        }
        throw new IllegalArgumentException("Typ: " + v.getClass().getCanonicalName());
    }
}

