/*
 * Decompiled with CFR 0.152.
 */
package utils.simplegraphs;

public class TimeValueModel {
    private long[] times = new long[0];
    private double[] values = new double[0];
    private int currentIndex = 0;
    private int total = 0;
    long overwriteEntriesWithinMS = -1L;
    boolean ignoreNaN = false;

    public void setOverwriteEntriesWithinMS(long ms) {
        this.overwriteEntriesWithinMS = ms;
    }

    public void setIgnoreNaNorInfinity(boolean b) {
        this.ignoreNaN = b;
    }

    public TimeValueModel(int maxSize) {
        this.times = new long[maxSize];
        this.values = new double[maxSize];
        this.currentIndex = 0;
    }

    public void addData(long time, double value) {
        if (this.ignoreNaN) {
            if (Double.isNaN(value)) {
                return;
            }
            if (Double.isInfinite(value)) {
                return;
            }
        }
        if (this.overwriteEntriesWithinMS != -1L && time - this.getLastTime() < this.overwriteEntriesWithinMS) {
            if (this.currentIndex > 0 && !Double.isNaN(value) && (value > this.values[this.currentIndex - 1] || Double.isNaN(this.values[this.currentIndex - 1]))) {
                this.values[this.currentIndex - 1] = value;
            }
            return;
        }
        this.times[this.currentIndex] = time;
        this.values[this.currentIndex] = value;
        if (this.total < this.times.length) {
            ++this.total;
        }
        this.currentIndex = (this.currentIndex + 1) % this.times.length;
    }

    public int getSize() {
        return this.total;
    }

    public long getTime(int index) {
        if (this.total < this.times.length) {
            return this.times[index];
        }
        int localIndex = (this.currentIndex + index) % this.times.length;
        return this.times[localIndex];
    }

    public double getValue(int index) {
        if (this.total < this.values.length) {
            return this.values[index];
        }
        int localIndex = (this.currentIndex + index) % this.times.length;
        return this.values[localIndex];
    }

    public long getLastTime() {
        if (this.currentIndex == 0) {
            if (this.total == 0) {
                return 0L;
            }
            return this.times[this.times.length - 1];
        }
        return this.times[this.currentIndex - 1];
    }

    public double getLastValue() {
        if (this.currentIndex == 0) {
            if (this.total == 0) {
                return Double.NaN;
            }
            return this.values[this.values.length - 1];
        }
        return this.values[this.currentIndex - 1];
    }
}

