/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.streams;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClearableBufferedInputStream
extends BufferedInputStream {
    private long totalRead = 0L;

    public ClearableBufferedInputStream(InputStream in, int size) {
        super(in, size);
    }

    public synchronized void clearBuffer() {
        this.pos = 0;
        this.count = 0;
        this.totalRead = 0L;
    }

    @Override
    public synchronized int read() throws IOException {
        int read = super.read();
        if (read > -1) {
            ++this.totalRead;
        }
        return read;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > -1) {
            this.totalRead += (long)read;
        }
        return read;
    }

    public long getTotalRead() {
        return this.totalRead;
    }

    public InputStream getInnerStream() {
        return this.in;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }
}

