/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.date;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class DateUtil {
    private static final DateFormat MONTH_FORMAT = new SimpleDateFormat("MMMM");
    private static final DateFormat DOW_FORMAT = new SimpleDateFormat("EE");

    public static int getDaysBetween(long startTime, long endTime) {
        long diff = Math.abs(endTime - startTime);
        if ((diff = diff / 1000L / 60L / 60L / 24L) > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)diff;
    }

    public static long oneYearAgo() {
        return DateUtil.nYearsAgo(1);
    }

    public static long nYearsAgo(int n) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.roll(1, -n);
        return c.getTimeInMillis();
    }

    public static int getYearsBetween(long startTime, long endTime) {
        return DateUtil.getDaysBetween(startTime, endTime) / 365;
    }

    public static long addYearTo(long timeMS) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMS);
        c.roll(1, true);
        return c.getTimeInMillis();
    }

    public static String getMonthString(int monthIndex) {
        Calendar c = Calendar.getInstance();
        c.set(2, monthIndex);
        return MONTH_FORMAT.format(c.getTime());
    }

    public static String getDayOfWeekString(int dayIndex) {
        Calendar c = Calendar.getInstance();
        c.set(7, dayIndex);
        return DOW_FORMAT.format(c.getTime());
    }

    public static int getWholeMonthsBetween(long date1, long date2) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTimeInMillis(date1);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTimeInMillis(date2);
        int totalMonths1 = endCalendar.get(1) * 12 + endCalendar.get(2);
        int totalMonths2 = startCalendar.get(1) * 12 + startCalendar.get(2);
        return Math.max(0, Math.abs(totalMonths1 - totalMonths2) - 1);
    }

    public static String getDayOfMonthSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static void main(String[] args) {
        Calendar c = Calendar.getInstance();
        c.set(2, c.get(2) - 1);
        DateFormat dateInstance = DateFormat.getDateInstance();
        System.out.println(dateInstance.format(c.getTime()) + " -> " + dateInstance.format(System.currentTimeMillis()) + " = " + DateUtil.getWholeMonthsBetween(System.currentTimeMillis(), c.getTimeInMillis()));
    }
}

