/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.arrays;

import java.util.Arrays;

public class BitStore {
    private byte[] bytes = new byte[1];

    public BitStore() {
    }

    public BitStore(byte[] existingStore) {
        this.bytes = existingStore;
    }

    public void set(int index, boolean value) {
        int byteIndex = index / 8;
        if (byteIndex >= this.bytes.length) {
            byte[] newBytes = new byte[byteIndex + 1];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            this.bytes = newBytes;
        }
        int offset = index % 8;
        int onIndex = 1 << offset;
        this.bytes[byteIndex] = value ? (byte)(this.bytes[byteIndex] | onIndex) : (byte)(this.bytes[byteIndex] & ~onIndex);
    }

    public boolean get(int index) {
        int byteIndex = index / 8;
        if (byteIndex >= this.bytes.length) {
            return false;
        }
        int offset = index % 8;
        int onIndex = 1 << offset;
        return (this.bytes[byteIndex] & onIndex) == onIndex;
    }

    public boolean exists(int index) {
        int byteIndex = index / 8;
        return byteIndex < this.bytes.length;
    }

    public byte[] getStore() {
        return this.bytes;
    }

    public void setStore(byte[] store) {
        this.bytes = store;
    }

    public void clear() {
        for (int i = 0; i < this.bytes.length; ++i) {
            this.bytes[i] = 0;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitStore) {
            return Arrays.equals(((BitStore)o).bytes, this.bytes);
        }
        return false;
    }

    public static void main(String[] args) {
        BitStore bs = new BitStore();
        bs.set(0, false);
        bs.set(1, true);
        bs.set(2, false);
        System.out.println(bs.bytes[0]);
    }
}

