/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.arrays;

import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Formatter;

public class ArrayPrinter {
    public static String print(Object[] array) {
        StringBuffer sb = new StringBuffer();
        for (int N = 0; N < array.length; ++N) {
            sb.append("" + array[N]);
            if (N >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String createIdentifyingHash(byte[] dat) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] digested = digest.digest(dat);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < digested.length; ++i) {
                byte b = digested[i];
                sb.append(String.format("%02X ", b));
            }
            return "{Array " + dat.length + " " + sb.toString() + "}";
        }
        catch (Exception x) {
            return "ERR-NO-HASH";
        }
    }

    private static String pad(String str, int len, char c) {
        if (str.length() > len) {
            return str;
        }
        char[] tmp = new char[len];
        Arrays.fill(tmp, c);
        System.arraycopy(str.toCharArray(), 0, tmp, 0, str.length());
        return new String(tmp);
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return sb.toString();
    }

    public static void print(byte[] array, int cols) {
        for (int N = 0; N < array.length; ++N) {
            if (N > 0 && N % cols == 0) {
                System.out.println();
            }
            System.out.print(ArrayPrinter.pad("" + array[N], 5, ' '));
        }
        System.out.println();
    }

    public static void print(byte[] array, int off, int len, int cols) {
        for (int N = 0; N < len; ++N) {
            if (N > 0 && N % cols == 0) {
                System.out.println();
            }
            System.out.print(ArrayPrinter.pad("" + array[N + off], 5, ' '));
        }
        System.out.println();
    }

    public static void printChars(byte[] array, int cols) {
        for (int N = 0; N < array.length; ++N) {
            char c;
            if (N > 0 && N % cols == 0) {
                System.out.println();
            }
            if (Character.isLetterOrDigit(c = (char)array[N])) {
                System.out.print("\t" + c);
                continue;
            }
            System.out.print("\t(" + array[N] + ")");
        }
        System.out.println();
    }

    public static void printTextContent(byte[] array) {
        boolean dot = false;
        for (int N = 0; N < array.length; ++N) {
            char c = (char)array[N];
            if (Character.isLetterOrDigit(c)) {
                System.out.print(c);
                dot = false;
                continue;
            }
            if (dot) continue;
            System.out.print(".");
            dot = true;
        }
        System.out.println();
    }

    public static void printDiff(byte[] array, byte[] array2, int cols) {
        for (int N = 0; N < array.length; ++N) {
            System.out.print("\t" + (array[N] - array2[N]));
            if (N % cols != 0) continue;
            System.out.println();
        }
    }
}

