/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

public class Ticker {
    TickerCounter counter;
    int max;
    int cur;
    Object LOCK = new Object();

    public Ticker(int max) {
        this.max = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.cur = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCounting(int ratePerSecond) {
        Object object = this.LOCK;
        synchronized (object) {
            this.stopCounting();
            this.counter = new TickerCounter(ratePerSecond);
            this.counter.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCounting() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.counter != null) {
                this.counter.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryClaim(int N) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cur > N) {
                this.cur -= N;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryClaim() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cur > 0) {
                --this.cur;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cur;
        }
    }

    public static void main(String[] args) throws Exception {
        int max = 10000;
        Ticker ticker = new Ticker(max);
        int N = 5000;
        ticker.startCounting(N);
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(1000L);
            System.out.println(ticker.getAvailable());
            if (i != 5) continue;
            int claimed = 0;
            for (int x = 0; x < max; ++x) {
                if (!ticker.tryClaim()) continue;
                ++claimed;
            }
            System.out.println("Claimed " + claimed);
        }
    }

    class TickerCounter
    extends Thread {
        boolean running = true;
        int ratePerSecond;

        public TickerCounter(int ratePerSecond) {
            this.ratePerSecond = ratePerSecond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                int tick = 1;
                long sleep = 1000 / this.ratePerSecond;
                if (sleep < 20L) {
                    sleep = 20L;
                    tick = this.ratePerSecond / 50;
                }
                System.out.println("[Ticker] Rate is " + tick + " per " + sleep + " = " + (long)tick * (1000L / sleep) + " vs " + this.ratePerSecond);
                while (this.running) {
                    Thread.sleep(sleep);
                    Object object = Ticker.this.LOCK;
                    synchronized (object) {
                        Ticker.this.cur += tick;
                        if (Ticker.this.cur > Ticker.this.max) {
                            Ticker.this.cur = Ticker.this.max;
                        }
                    }
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

