/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import utils.progtools.clock.TimingClock;

public class Stopwatch {
    long started = TimingClock.currentTimeMillis();
    long maxMs;

    public Stopwatch() {
    }

    public Stopwatch(long maxMs) {
        this.maxMs = maxMs;
    }

    public Stopwatch(double maxMins) {
        this.maxMs = (long)(60000.0 * maxMins);
    }

    public void reset() {
        this.started = TimingClock.currentTimeMillis();
    }

    public long getElapsed() {
        return TimingClock.currentTimeMillis() - this.started;
    }

    public boolean resetIfMaxed() {
        if (this.getElapsed() > this.maxMs) {
            this.reset();
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        Stopwatch sw = new Stopwatch(1000L);
        while (true) {
            Thread.sleep(10L);
            if (!sw.resetIfMaxed()) continue;
            System.out.println("Bing " + System.currentTimeMillis() % 10000L);
        }
    }
}

