/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.Semaphore;
import java.util.zip.GZIPOutputStream;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.PipelineJob;

public class OnDemandPipeline {
    OnDemandThreadPool multi;
    Semaphore sem;
    Object LOCK = new Object();
    LinkedList<PipelineJob> jobs = new LinkedList();
    int concurrency;

    public int getConcurrency() {
        return this.concurrency;
    }

    public OnDemandPipeline() {
        this(Runtime.getRuntime().availableProcessors() * 3);
    }

    public OnDemandPipeline(int concurrency) {
        this.concurrency = concurrency;
        this.multi = new OnDemandThreadPool("Pipeline", concurrency, Integer.MAX_VALUE, 5);
        this.sem = new Semaphore(concurrency);
        System.out.println("Pipeline concurrency is " + concurrency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(final PipelineJob job) {
        Object object = this.LOCK;
        synchronized (object) {
            this.jobs.add(job);
        }
        try {
            this.sem.acquire();
        }
        catch (InterruptedException x) {
            x.printStackTrace();
        }
        this.multi.runAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                try {
                    job.parallelTask();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                boolean meNext = false;
                while (!meNext) {
                    object = OnDemandPipeline.this.LOCK;
                    synchronized (object) {
                        if (job == OnDemandPipeline.this.jobs.peek()) {
                            meNext = true;
                        } else {
                            try {
                                OnDemandPipeline.this.LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                try {
                    job.finalOrderedTask();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                object = OnDemandPipeline.this.LOCK;
                synchronized (object) {
                    OnDemandPipeline.this.jobs.poll();
                    OnDemandPipeline.this.LOCK.notifyAll();
                    OnDemandPipeline.this.sem.release();
                }
            }
        });
    }

    public static void main(String[] args) {
        OnDemandPipeline pipeline = new OnDemandPipeline();
        final byte[] dat = new byte[100000];
        new Random().nextBytes(dat);
        int MAX = 2000;
        final long T = System.currentTimeMillis();
        int i = 1;
        while (i <= 2000) {
            final int myIndex = i++;
            pipeline.add(new PipelineJob(){

                public String toString() {
                    return "Job " + myIndex;
                }

                @Override
                public void parallelTask() {
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream(dat.length);
                        GZIPOutputStream gout = new GZIPOutputStream(bout);
                        gout.write(dat);
                        gout.finish();
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }

                @Override
                public void finalOrderedTask() {
                    if (myIndex == 2000) {
                        System.out.println("task " + myIndex + " done after " + (System.currentTimeMillis() - T) + "ms");
                    }
                }
            });
        }
    }
}

