/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.filters.LogFilter;
import utils.loggingframework.targets.VariableUtil;
import utils.swing.SwingStyleInterface;
import utils.swing.components.SHComboBox;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;

public class SpecifyFiltersUI
implements ActionListener {
    private GbPanel rootComponent = new GbPanel();
    private ResourceBundle bundle;
    private LogEvent[] selectedEvents;
    private JRadioButton noFilters;
    private JRadioButton selectedFilters;
    private GbPanel filterListPanel;
    private JButton newFilterButton;
    private ArrayList<FilterUI> filterUIList = new ArrayList();
    private ActionListener actionListener;
    private SwingStyleInterface style;
    private GbPanel newFilterButtonPanel;

    public Component getRootComponent() {
        return this.rootComponent;
    }

    public SpecifyFiltersUI(ResourceBundle bundle, SwingStyleInterface style, ActionListener actionListener) {
        this.bundle = bundle;
        this.actionListener = actionListener;
        this.style = style;
        this.initUI();
    }

    public void setEvents(LogEvent[] events) {
        if (this.selectedEvents != null && Arrays.equals(this.selectedEvents, events)) {
            return;
        }
        this.selectedEvents = events;
        boolean enabled = this.selectedEvents != null && events.length != 0;
        this.noFilters.setEnabled(enabled);
        this.selectedFilters.setEnabled(enabled);
        this.filterListPanel.setEnabled(enabled);
        for (FilterUI aFilterUIList : this.filterUIList) {
            aFilterUIList.setEnabled(enabled);
        }
    }

    public void loadFromExistingFilters(LogFilter[] existingFilters) {
        this.filterListPanel.removeAll();
        this.filterUIList.clear();
        int Y = 0;
        if (existingFilters != null) {
            for (LogFilter filter : existingFilters) {
                FilterUI ui = new FilterUI(filter);
                this.filterUIList.add(ui);
                this.filterListPanel.add(ui.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 2);
            }
        }
        this.filterListPanel.add((Component)this.newFilterButtonPanel, 0, Y++, 1, 1, 1, 1000, 10, 1);
        if (existingFilters == null || existingFilters.length == 0) {
            this.noFilters.setSelected(true);
            this.newFilterButton.setEnabled(false);
        } else {
            this.selectedFilters.setSelected(true);
            this.newFilterButton.setEnabled(true);
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void updateEnabled() {
        boolean filtersEnabled = this.selectedFilters.isSelected();
        this.filterListPanel.setEnabled(filtersEnabled);
        this.newFilterButton.setEnabled(filtersEnabled);
        for (FilterUI aFilterUIList : this.filterUIList) {
            aFilterUIList.setEnabled(filtersEnabled);
        }
    }

    public boolean isComplete() {
        if (this.noFilters == null) {
            return false;
        }
        if (this.noFilters.isSelected()) {
            return true;
        }
        if (this.filterUIList.size() == 0) {
            return false;
        }
        for (FilterUI aFilterUIList : this.filterUIList) {
            FilterUI ui = aFilterUIList;
            if (ui.isComplete()) continue;
            return false;
        }
        return true;
    }

    private void initUI() {
        this.noFilters = new JRadioButton(this.bundle.getString("LOGGING_INCLUDE_ALL_EVENTS"));
        this.selectedFilters = new JRadioButton(this.bundle.getString("LOGGING_INCLUDE_FILTERED_EVENTS"));
        this.noFilters.setEnabled(false);
        this.selectedFilters.setEnabled(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.noFilters);
        group.add(this.selectedFilters);
        this.filterListPanel = new GbPanel();
        this.filterListPanel.setBackground(UIManager.getColor("TextField.background"));
        JScrollPane sp = new JScrollPane((Component)this.filterListPanel);
        sp.setBackground(UIManager.getColor("TextField.background"));
        this.newFilterButtonPanel = new GbPanel();
        this.newFilterButtonPanel.setBackground(UIManager.getColor("TextField.background"));
        this.newFilterButton = new JButton(this.bundle.getString("LOGGING_ADD_FILTER"));
        this.newFilterButton.setEnabled(false);
        Font smallFont = SHStyle.smallerFont;
        this.newFilterButton.setFont(smallFont);
        this.newFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFilter filter = new LogFilter(null);
                SpecifyFiltersUI.this.addFilterToListPanels(filter);
                SpecifyFiltersUI.this.filterListPanel.revalidate();
                SpecifyFiltersUI.this.filterListPanel.repaint();
                SpecifyFiltersUI.this.actionListener.actionPerformed(null);
            }
        });
        GbPanel paddy2 = new GbPanel();
        paddy2.setBackground(UIManager.getColor("TextField.background"));
        this.newFilterButtonPanel.add((Component)this.newFilterButton, 0, 0, 1, 1, 1, 0, 10, 0, (Insets)new ScaledInsets(5, 5, 5, 5));
        this.newFilterButtonPanel.add((Component)paddy2, 0, 1, 1, 1, 1, 1000, 10, 1);
        this.filterListPanel.add((Component)this.newFilterButtonPanel, 0, 3, 1, 1, 1, 1000, 10, 1);
        int Y = 0;
        this.rootComponent.add((Component)this.noFilters, 0, Y++, 1, 1, 1, 0, 17, 0);
        this.rootComponent.add((Component)this.selectedFilters, 0, Y++, 1, 1, 1, 0, 17, 0);
        this.rootComponent.add((Component)sp, 0, Y++, 1, 1, 1, 10000, 17, 1);
        this.noFilters.addActionListener(this);
        this.selectedFilters.addActionListener(this);
    }

    private void addFilterToListPanels(LogFilter filter) {
        Component paddy = this.filterListPanel.getComponent(this.filterListPanel.getComponentCount() - 1);
        this.filterListPanel.remove(paddy);
        FilterUI ui = new FilterUI(filter);
        this.filterUIList.add(ui);
        this.filterListPanel.add(ui.getRootComponent(), 0, this.filterListPanel.getComponentCount(), 1, 1, 1, 0, 10, 2);
        this.filterListPanel.add(paddy, 0, this.filterListPanel.getComponentCount(), 1, 1, 1, 10000, 10, 1);
    }

    public void removeFilter(final FilterUI filterUI) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpecifyFiltersUI.this.filterUIList.remove(filterUI);
                SpecifyFiltersUI.this.filterListPanel.remove(filterUI.getRootComponent());
                SpecifyFiltersUI.this.filterListPanel.revalidate();
                SpecifyFiltersUI.this.filterListPanel.repaint();
                SpecifyFiltersUI.this.actionListener.actionPerformed(null);
            }
        });
    }

    public LogFilter[] getFilters() {
        if (this.noFilters.isSelected()) {
            return new LogFilter[0];
        }
        LogFilter[] allFilters = new LogFilter[this.filterUIList.size()];
        for (int i = 0; i < this.filterUIList.size(); ++i) {
            allFilters[i] = this.filterUIList.get(i).getFilter();
        }
        return allFilters;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionListener.actionPerformed(e);
        this.updateEnabled();
    }

    public class FilterUI
    implements ActionListener {
        private GbPanel filterRoot = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        private SHComboBox actionBox;
        private SHComboBox eventsBox;
        private SHComboBox fieldBox;
        private JTextField actionTextField = new JTextField();
        private JLabel deleteLabel;
        private boolean loading = false;

        public Component getRootComponent() {
            return this.filterRoot;
        }

        public void setEnabled(boolean enabled) {
            this.actionBox.setEnabled(enabled);
            this.eventsBox.setEnabled(enabled);
            this.fieldBox.setEnabled(enabled);
            this.actionTextField.setEnabled(enabled);
            this.deleteLabel.setEnabled(enabled);
        }

        public boolean isComplete() {
            return this.actionTextField.getText().trim().length() > 0;
        }

        public FilterUI(LogFilter filter) {
            this.initUI(filter);
        }

        private void initUI(LogFilter initFilter) {
            this.filterRoot.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            JLabel includeLabel = new JLabel(SpecifyFiltersUI.this.bundle.getString("LOG"));
            JLabel eventsIfLabel = new JLabel(SpecifyFiltersUI.this.bundle.getString("IF"));
            this.actionBox = new SHComboBox(new Object[]{SpecifyFiltersUI.this.bundle.getString("EQUALS"), SpecifyFiltersUI.this.bundle.getString("NOT_EQUALS"), SpecifyFiltersUI.this.bundle.getString("CONTAINS"), SpecifyFiltersUI.this.bundle.getString("DOES_NOT_CONTAIN"), SpecifyFiltersUI.this.bundle.getString("IS_LESS_THAN"), SpecifyFiltersUI.this.bundle.getString("IS_GREATER_THAN")});
            this.makeNaked((JComboBox)this.actionBox);
            this.eventsBox = new SHComboBox((Object[])SpecifyFiltersUI.this.selectedEvents);
            this.makeNaked((JComboBox)this.eventsBox);
            String[] commonVariableNames = VariableUtil.getCommonVariableNames(SpecifyFiltersUI.this.selectedEvents);
            Object[] variablesPlusAll = new String[commonVariableNames.length + 1];
            variablesPlusAll[0] = SpecifyFiltersUI.this.bundle.getString("ANY_FIELD");
            System.arraycopy(commonVariableNames, 0, variablesPlusAll, 1, commonVariableNames.length);
            this.fieldBox = new SHComboBox(variablesPlusAll);
            this.makeNaked((JComboBox)this.fieldBox);
            this.eventsBox.addActionListener((ActionListener)this);
            this.actionBox.addActionListener((ActionListener)this);
            this.fieldBox.addActionListener((ActionListener)this);
            this.deleteLabel = new JLabel(SpecifyFiltersUI.this.style.getDisabledImageIcon("images/svg/general/remove.svg,16"));
            this.deleteLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    FilterUI.this.deleteFilter();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(SpecifyFiltersUI.this.style.getImageIcon("images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    FilterUI.this.deleteLabel.setIcon(SpecifyFiltersUI.this.style.getDisabledImageIcon("images/svg/general/remove.svg,16"));
                    FilterUI.this.deleteLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            int X = 0;
            this.filterRoot.add((Component)includeLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            this.filterRoot.add((Component)this.eventsBox, X++, 0, 1, 1, 0, 1, 10, 1);
            this.filterRoot.add((Component)eventsIfLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            this.filterRoot.add((Component)this.fieldBox, X++, 0, 1, 1, 0, 1, 10, 1);
            this.filterRoot.add((Component)this.actionBox, X++, 0, 1, 1, 0, 1, 10, 1);
            this.filterRoot.add((Component)this.actionTextField, X++, 0, 1, 1, 1, 1, 10, 1);
            this.filterRoot.add((Component)this.deleteLabel, X++, 0, 1, 1, 0, 1, 10, 1);
            this.loadFromFilter(initFilter);
            this.actionTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!FilterUI.this.loading) {
                        SpecifyFiltersUI.this.actionListener.actionPerformed(null);
                    }
                }
            });
            Font smallFont = SHStyle.smallerFont;
            includeLabel.setFont(smallFont);
            eventsIfLabel.setFont(smallFont);
            this.fieldBox.setFont(smallFont);
            this.eventsBox.setFont(smallFont);
            this.actionBox.setFont(smallFont);
            this.actionTextField.setFont(smallFont);
        }

        private void deleteFilter() {
            SpecifyFiltersUI.this.removeFilter(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadFromFilter(LogFilter initFilter) {
            try {
                this.loading = true;
                this.actionBox.setSelectedIndex(initFilter.getCheckAction());
                String eventIDToFilter = initFilter.getLogEventIDToFilter();
                if (eventIDToFilter != null) {
                    for (int i = 0; i < SpecifyFiltersUI.this.selectedEvents.length; ++i) {
                        if (!eventIDToFilter.equals(SpecifyFiltersUI.this.selectedEvents[i].getID())) continue;
                        this.eventsBox.setSelectedIndex(i);
                        break;
                    }
                }
                if (initFilter.isCheckAllFields()) {
                    this.fieldBox.setSelectedIndex(0);
                } else {
                    this.fieldBox.setSelectedItem((Object)initFilter.getFieldNameToFilter());
                }
                this.actionTextField.setText(initFilter.getCheckActionText());
            }
            finally {
                this.loading = false;
            }
        }

        private void makeNaked(JComboBox box) {
            box.putClientProperty("NAKED", "YES");
        }

        public LogFilter getFilter() {
            LogEvent selectedEvent = (LogEvent)this.eventsBox.getSelectedItem();
            if (this.fieldBox.getSelectedIndex() == 0) {
                return new LogFilter(selectedEvent.getID(), true, null, this.actionBox.getSelectedIndex(), this.actionTextField.getText());
            }
            return new LogFilter(selectedEvent.getID(), false, this.fieldBox.getSelectedItem().toString(), this.actionBox.getSelectedIndex(), this.actionTextField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.loading) {
                SpecifyFiltersUI.this.actionListener.actionPerformed(null);
            }
        }
    }
}

