/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.TargetUIListener;
import utils.loggingframework.ui.SelectTargetComponent;
import utils.swing.SwingStyleInterface;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.layout.GbPanel;

public class MultipleSelectTargetComponent
implements ActionListener {
    private CompoundTargetUIListener compoundTargetUIListener;
    private final ResourceBundle lang;
    private final TargetUIListener canProceedListener;
    private final SwingStyleInterface style;
    private final boolean showPerMachineOption;
    private GbPanel rootComponent = new GbPanel();
    private JScrollPane pane;
    private GbPanel listComponent = new GbPanel();
    private StrippedContentPanel contentPanel = new StrippedContentPanel(this.listComponent, null, null);
    private ArrayList<SelectTargetComponent> targetComponents = new ArrayList();
    private JButton addNewTargetButton;
    private LogEvent[] logEventsToTarget;
    private Class[] targetsToIgnore;

    public MultipleSelectTargetComponent(ResourceBundle lang, TargetUIListener canProceedListener, SwingStyleInterface style, boolean showPerMachineOption, Class[] targetsToIgnore) {
        this.lang = lang;
        this.targetsToIgnore = targetsToIgnore;
        this.canProceedListener = canProceedListener;
        this.style = style;
        this.showPerMachineOption = showPerMachineOption;
        this.initUI();
    }

    public void setTargets(ArrayList<AbstractTarget> targets) {
        this.listComponent.removeAll();
        this.targetComponents.clear();
        for (AbstractTarget target : targets) {
            this.createNewTarget(target);
        }
    }

    public ArrayList<AbstractTarget> getTargets() {
        ArrayList<AbstractTarget> result = new ArrayList<AbstractTarget>();
        for (SelectTargetComponent targetComponent : this.targetComponents) {
            result.add(targetComponent.getSelectedAbstractTarget());
        }
        return result;
    }

    private void initUI() {
        this.addNewTargetButton = new JButton(this.lang.getString("NEW_ACTION"));
        this.pane = new JScrollPane((Component)this.listComponent);
        this.pane.setBorder(SHBorderFactory.createEmptyBorder());
        GbPanel newActionPanel = new GbPanel();
        newActionPanel.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3)));
        newActionPanel.add((Component)this.addNewTargetButton, 0, 0, 1, 1, 1, 1, 10, 0);
        this.rootComponent.add((Component)this.pane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)newActionPanel, 0, 1, 1, 1, 1, 0, 10, 1);
        this.addNewTargetButton.addActionListener(this);
        this.compoundTargetUIListener = new CompoundTargetUIListener(this.canProceedListener);
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addNewTargetButton) {
            this.createNewTarget();
            this.compoundTargetUIListener.targetChanged();
        }
    }

    private void createNewTarget() {
        StateTargetUIListener stateListener = new StateTargetUIListener(this.compoundTargetUIListener);
        SelectTargetComponent newTarget = new SelectTargetComponent(this.lang, stateListener, this.style, this.showPerMachineOption, this.targetsToIgnore);
        newTarget.setLogEventsToTarget(this.logEventsToTarget);
        this.addNewTarget(newTarget);
    }

    private void createNewTarget(AbstractTarget target) {
        StateTargetUIListener stateListener = new StateTargetUIListener(this.compoundTargetUIListener);
        SelectTargetComponent newTarget = new SelectTargetComponent(this.lang, stateListener, this.style, this.showPerMachineOption, this.targetsToIgnore);
        newTarget.setLogEventsToTarget(this.logEventsToTarget);
        newTarget.load(target);
        this.addNewTarget(newTarget);
    }

    private void addNewTarget(SelectTargetComponent newTarget) {
        this.contentPanel.removeVerticalFiller();
        this.targetComponents.add(newTarget);
        this.contentPanel.addContent(newTarget.getComponent(), null);
        this.contentPanel.addVerticalFiller();
        this.contentPanel.setBackgroundColours();
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    private void removeTarget(SelectTargetComponent target) {
        this.targetComponents.remove(target);
        this.contentPanel.removeContent(target.getComponent());
        this.compoundTargetUIListener.targetChanged();
    }

    public void setLogEventsToTarget(LogEvent[] logEventsToTarget) {
        this.logEventsToTarget = logEventsToTarget;
    }

    protected AbstractTarget[] filterTargetInstances(AbstractTarget[] instances) {
        return instances;
    }

    static interface MultiTargetUIListener
    extends TargetUIListener {
        public void remove(SelectTargetComponent var1);
    }

    class CompoundTargetUIListener
    implements TargetUIListener {
        private final TargetUIListener rootListener;
        private final ArrayList<StateTargetUIListener> listeners = new ArrayList();

        public CompoundTargetUIListener(TargetUIListener rootListener) {
            this.rootListener = rootListener;
        }

        public void addChildListener(StateTargetUIListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void targetUIComplete() {
            for (StateTargetUIListener listener : this.listeners) {
                if (listener.isUIComplete) continue;
                return;
            }
            this.rootListener.targetUIComplete();
        }

        @Override
        public void targetUIIncomplete() {
            this.rootListener.targetUIComplete();
        }

        @Override
        public void targetChanged() {
            this.rootListener.targetChanged();
        }
    }

    class StateTargetUIListener
    implements MultiTargetUIListener {
        boolean isUIComplete;
        TargetUIListener parentListener;

        public StateTargetUIListener(TargetUIListener rootListener) {
            this.parentListener = rootListener;
        }

        @Override
        public void targetUIComplete() {
            this.isUIComplete = true;
            this.parentListener.targetUIComplete();
        }

        @Override
        public void targetUIIncomplete() {
            this.isUIComplete = false;
            this.parentListener.targetUIIncomplete();
        }

        @Override
        public void targetChanged() {
            this.parentListener.targetChanged();
        }

        @Override
        public void remove(SelectTargetComponent selectTargetComponent) {
            MultipleSelectTargetComponent.this.removeTarget(selectTargetComponent);
        }
    }
}

