/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.targets;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.w3c.dom.Element;
import utils.loggingframework.LoggingVersion;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.TargetRepository;
import utils.loggingframework.targets.TargetUI;
import utils.message.Message;

public abstract class AbstractTarget
extends LoggingVersion {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss: ");
    protected ResourceBundle bundle;

    public abstract String getID();

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getTargetSummary();

    public abstract void logEvent(LogEvent var1) throws Exception;

    public abstract boolean isAvailableTarget();

    public abstract TargetUI getTargetUI();

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public boolean equals(Object o) {
        AbstractTarget at;
        return o instanceof AbstractTarget && (at = (AbstractTarget)o).getID().equals(this.getID());
    }

    public String toString() {
        return this.getName();
    }

    public String getTimeStamp() {
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    public String saveToXML(int indent) {
        StringBuffer buffer = new StringBuffer();
        this.saveToXML(buffer, indent);
        return buffer.toString();
    }

    public void toMessage(Message m) {
        m.append(this.version);
        m.append(this.getID());
    }

    public static AbstractTarget loadFromMessage(Message m, ResourceBundle bundle) {
        if (m.length() == 0) {
            return null;
        }
        byte version = m.getNextByte();
        String id = m.getNextString();
        Class<? extends AbstractTarget> targetClass = TargetRepository.INSTANCE.getTargetClass(id);
        try {
            AbstractTarget target = targetClass.newInstance();
            target.setBundle(bundle);
            target.fromMessage(version, m);
            return target;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    protected abstract void fromMessage(byte var1, Message var2);

    protected abstract void saveToXML(StringBuffer var1, int var2);

    protected abstract void loadFromXML(Element var1);

    public static AbstractTarget fromXML(Element root, ResourceBundle bundle) throws Exception {
        String id = root.getTagName();
        Class<? extends AbstractTarget> targetClass = TargetRepository.INSTANCE.getTargetClass(id);
        AbstractTarget target = targetClass.newInstance();
        target.setBundle(bundle);
        target.loadFromXML(root);
        return target;
    }
}

