/*
 * Decompiled with CFR 0.152.
 */
package utils.loggingframework.filters;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import utils.loggingframework.LoggingVersion;
import utils.loggingframework.events.LogEvent;
import utils.message.Message;

public class LogFilter
extends LoggingVersion {
    public static final int CHECK_ACTION_EQUALS = 0;
    public static final int CHECK_ACTION_NEQUALS = 1;
    public static final int CHECK_ACTION_CONTAINS = 2;
    public static final int CHECK_ACTION_NCONTAINS = 3;
    public static final int CHECK_ACTION_LESS_THAN = 4;
    public static final int CHECK_ACTION_GREATER_THAN = 5;
    private String eventIDToFilter;
    private boolean checkAllFields = true;
    private String fieldNameToFilter;
    private int checkAction;
    private String checkActionText;
    private static final NumberFormat NUMBER_FORMAT = DecimalFormat.getNumberInstance();

    private LogFilter() {
        this(null, true, null, 0, "");
    }

    public static LogFilter newFromMessage(Message m) {
        LogFilter filter = new LogFilter();
        filter.fromMessage(m);
        return filter;
    }

    public LogFilter(String eventIDToFilter) {
        this(eventIDToFilter, true, null, 0, "");
    }

    public LogFilter(String eventIDToFilter, boolean checkAllFields, String fieldNameToFilter, int checkAction, String checkActionText) {
        this.eventIDToFilter = eventIDToFilter;
        this.checkAllFields = checkAllFields;
        this.fieldNameToFilter = fieldNameToFilter;
        this.checkAction = checkAction;
        this.checkActionText = checkActionText;
    }

    public Object clone() {
        LogFilter newFilter = new LogFilter(this.eventIDToFilter, this.checkAllFields, this.fieldNameToFilter, this.checkAction, this.checkActionText);
        return newFilter;
    }

    public String getLogEventIDToFilter() {
        return this.eventIDToFilter;
    }

    public boolean isCheckAllFields() {
        return this.checkAllFields;
    }

    public String getFieldNameToFilter() {
        return this.fieldNameToFilter;
    }

    public int getCheckAction() {
        return this.checkAction;
    }

    public String getCheckActionText() {
        return this.checkActionText;
    }

    public boolean includeEvent(LogEvent event) {
        if (!this.canFilterEvent(event)) {
            return false;
        }
        if (this.checkAllFields) {
            LogEvent.LogEventVariable[] variables;
            for (LogEvent.LogEventVariable variable : variables = event.getVariables()) {
                String variableValue = event.getValueForVariable(variable.getId());
                boolean isIncluded = this.checkIsIncludedByFilter(variableValue);
                if (!isIncluded) continue;
                return true;
            }
            return false;
        }
        if (this.fieldNameToFilter == null) {
            return true;
        }
        String variableValue = event.getValueForVariable(this.fieldNameToFilter);
        return this.checkIsIncludedByFilter(variableValue);
    }

    private boolean checkIsIncludedByFilter(String variableValue) {
        switch (this.checkAction) {
            case 0: {
                return variableValue.equals(this.checkActionText);
            }
            case 1: {
                return !variableValue.equals(this.checkActionText);
            }
            case 2: {
                return variableValue.indexOf(this.checkActionText) != -1;
            }
            case 3: {
                return variableValue.indexOf(this.checkActionText) == -1;
            }
            case 4: {
                return this.isLessThan(variableValue, this.checkActionText);
            }
            case 5: {
                return this.isGreaterThan(variableValue, this.checkActionText);
            }
        }
        return false;
    }

    private boolean isNumber(String value) {
        try {
            NUMBER_FORMAT.parse(value);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isGreaterThan(String value1, String value2) {
        if (this.isNumber(value1) && this.isNumber(value2)) {
            try {
                double val1 = NUMBER_FORMAT.parse(value1).doubleValue();
                double val2 = NUMBER_FORMAT.parse(value2).doubleValue();
                return val1 > val2;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return value1.compareTo(value2) > 0;
    }

    private boolean isLessThan(String value1, String value2) {
        if (this.isNumber(value1) && this.isNumber(value2)) {
            try {
                double val1 = NUMBER_FORMAT.parse(value1).doubleValue();
                double val2 = NUMBER_FORMAT.parse(value2).doubleValue();
                return val1 < val2;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return value1.compareTo(value2) < 0;
    }

    private boolean canFilterEvent(LogEvent event) {
        return event.getID().equals(this.eventIDToFilter);
    }

    private String indentation(int size) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }

    public void toMessage(Message m) {
        m.append(this.version);
        m.append(this.eventIDToFilter);
        m.append(this.checkAllFields);
        m.append(this.fieldNameToFilter);
        m.append(this.checkAction);
        m.append(this.checkActionText);
    }

    public void fromMessage(Message m) {
        this.version = m.getNextByte();
        this.eventIDToFilter = m.getNextString();
        this.checkAllFields = m.getNextBoolean();
        this.fieldNameToFilter = m.getNextString();
        this.checkAction = m.getNextInt();
        this.checkActionText = m.getNextString();
    }

    public String saveToXML(int indentationTabs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.indentation(indentationTabs)).append("<Filter>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<EventToFilter>" + this.eventIDToFilter + "</EventToFilter>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<CheckAllFields>" + this.checkAllFields + "</CheckAllFields>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<FieldNameToFilter>" + this.fieldNameToFilter + "</FieldNameToFilter>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<CheckAction>" + this.checkAction + "</CheckAction>\n");
        buffer.append(this.indentation(indentationTabs + 1)).append("<CheckActionText>" + this.checkActionText + "</CheckActionText>\n");
        buffer.append(this.indentation(indentationTabs)).append("</Filter>\n");
        return buffer.toString();
    }

    public static LogFilter loadFromXML(Element childElement) {
        String eventID = childElement.getElementsByTagName("EventToFilter").item(0).getTextContent();
        boolean checkAllFields = Boolean.parseBoolean(childElement.getElementsByTagName("CheckAllFields").item(0).getTextContent());
        NodeList childList = childElement.getElementsByTagName("FieldNameToFilter");
        String fieldNameToFilter = childList.getLength() > 0 ? childList.item(0).getTextContent() : null;
        String checkActionText = childElement.getElementsByTagName("CheckActionText").item(0).getTextContent();
        int checkAction = Integer.parseInt(childElement.getElementsByTagName("CheckAction").item(0).getTextContent());
        return new LogFilter(eventID, checkAllFields, fieldNameToFilter, checkAction, checkActionText);
    }
}

