/*
 * Decompiled with CFR 0.152.
 */
package utils.email;

import com.simplehelp.credentials.MailCredentials;
import utils.email.CommonEmailer;
import utils.email.HtmlEmailer;

public class Emailer {
    private static final int RETRIES = 5;
    private static final Object LOCK = new Object();
    private HtmlEmailer emailer;

    public Emailer(MailCredentials credentials) {
        this.emailer = new HtmlEmailer(CommonEmailer.PROVIDER_GMAIL, credentials.getUsername(), credentials.getPassword(), credentials.getSendingAddress(), "UTF-8");
    }

    private void retryRun(EmailSend run) {
        boolean success = false;
        int count = 0;
        while (count < 5 && !success) {
            if (count > 0) {
                try {
                    int sleep = count <= 1 ? 1000 : (count == 2 ? 10000 : 60000);
                    Thread.sleep(sleep);
                }
                catch (InterruptedException sleep) {
                    // empty catch block
                }
            }
            ++count;
            try {
                run.sendEmail();
                success = true;
            }
            catch (Throwable t) {
                System.out.println("[Emailer] Attempt " + count + " / " + 5 + " failed.");
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDraftGmailEmail(final String to, final String subject, final String content, final String mime, final CommonEmailer.EmailAttachment[] attachedFiles) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.createDraftGmailEmail(to, subject, content, mime, attachedFiles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final String subject, final String content) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.send(subject, content);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final String[] to, final String subject, final String content) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.send(to, subject, content);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final String[] to, final String subject, final String content, final String mime, final CommonEmailer.EmailAttachment[] attachedFiles, final String[] replyTo) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.send(to, subject, content, mime, attachedFiles, replyTo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final String[] to, final String subject, final String content, final String mime, final CommonEmailer.EmailAttachment[] attachedFiles, final String[] replyTo, final String from) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.send(to, subject, content, mime, attachedFiles, replyTo, from);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHtmlAndPlainTextEmail(final String[] to, final String subject, final String plaintTextContent, final String htmlContent, final String[] replyTo, final String overrideFrom, final CommonEmailer.EmailAttachment[] attachedFiles) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.sendHtmlAndPlainTextEmail(to, subject, plaintTextContent, htmlContent, replyTo, overrideFrom, attachedFiles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHtmlAndPlainTextEmail(final String[] to, final String[] cc, final String subject, final String plaintTextContent, final String htmlContent, final String[] replyTo, final String overrideFrom, final CommonEmailer.EmailAttachment[] attachedFiles) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.sendHtmlAndPlainTextEmail(to, cc, subject, plaintTextContent, htmlContent, replyTo, overrideFrom, attachedFiles);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(final String[] to, final String subject, final String content, final String mime, final CommonEmailer.EmailAttachment[] attachedFiles) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            this.retryRun(new EmailSend(){

                @Override
                public void sendEmail() throws Exception {
                    Emailer.this.emailer.send(to, subject, content, mime, attachedFiles);
                }
            });
        }
    }

    private static interface EmailSend {
        public void sendEmail() throws Exception;
    }
}

