/*
 * Decompiled with CFR 0.152.
 */
package utils.ddebug;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.stream.StreamUtils;
import utils.string.CharStack;
import utils.switches.Switches;

public class DDLog {
    static int LOG = 0;
    static int ALIAS = 1;
    static int PROCESS = 2;
    static int MASTER = 3;
    static DDLog stat;
    Object LOCK = new Object();
    Socket sock;
    OutputStream out;
    HashMap map = new HashMap();

    private static void startup() {
        if (stat == null) {
            try {
                stat = new DDLog();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public DDLog() throws Exception {
        try {
            String addresses = StreamUtils.readAllAsStringUTF8((InputStream)new URL("http://jwrapper.com/ddebug_aem.html").openStream());
            CharStack cs = new CharStack(addresses);
            while (!cs.isEmpty()) {
                cs.popUntil("DDADDR", false);
                cs.popUntil(":", false);
                String addr = cs.popJavaFullClassname(true);
                cs.pop();
                int port = (int)cs.popNumber();
                System.out.println("[DDLog] DD Address - " + addr + ":" + port);
                try {
                    this.sock = new Socket(addr, port);
                    this.out = new BufferedOutputStream(this.sock.getOutputStream());
                    System.out.println("[DDLog] connected to " + addr + ":" + port);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcess(String proc) {
        DDLog.startup();
        Message m = new Message(PROCESS);
        m.append(proc);
        Object object = DDLog.stat.LOCK;
        synchronized (object) {
            try {
                MessageUtils.writeMessage((OutputStream)DDLog.stat.out, (Message)m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void aliasMaster(Object master, Object toe) {
        DDLog.startup();
        Object object = DDLog.stat.LOCK;
        synchronized (object) {
            String mastere = "" + master;
            String tofe = "" + toe;
            if (!DDLog.stat.map.containsKey(mastere)) {
                DDLog.stat.map.put(mastere, mastere);
                Message m = new Message(MASTER);
                m.append(mastere);
                m.append(tofe);
                try {
                    MessageUtils.writeMessage((OutputStream)DDLog.stat.out, (Message)m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void alias(Object toe1, Object toe2) {
        DDLog.startup();
        String tofe1 = "" + toe1;
        String tofe2 = "" + toe2;
        Message m = new Message(ALIAS);
        m.append(tofe1);
        m.append(tofe2);
        Object object = DDLog.stat.LOCK;
        synchronized (object) {
            if (!DDLog.stat.map.containsKey(tofe1 + "|" + tofe2)) {
                try {
                    MessageUtils.writeMessage((OutputStream)DDLog.stat.out, (Message)m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DDLog.stat.map.put(tofe1 + "|" + tofe2, tofe1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(Object tofe, Object o) {
        if (Switches.SH_DDLogOutputToStdout) {
            System.out.println("[DDLog-" + tofe + "] " + o);
        } else {
            DDLog.startup();
            String toe = "" + tofe;
            String log = "" + o;
            Message m = new Message(LOG);
            m.append(toe);
            m.append(log);
            Object object = DDLog.stat.LOCK;
            synchronized (object) {
                try {
                    MessageUtils.writeMessage((OutputStream)DDLog.stat.out, (Message)m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DDLog.startup();
        DDLog.setProcess("Test");
        DDLog.aliasMaster("Test TofE", "Three");
        DDLog.log("One", "Hi");
        DDLog.log("Two", "Still me");
        DDLog.alias("One", "Two");
        DDLog.log("One", "Hi");
        DDLog.log("Two", "Still me");
        DDLog.alias("Three", "Four");
        DDLog.log("One", "Hi");
        DDLog.log("Two", "Still me");
        DDLog.alias("Two", "Four");
        DDLog.log("One", "Hi");
        DDLog.log("Two", "Still me");
        DDLog.log("Three", "Me too");
        DDLog.log("Four", "And me!");
    }
}

