/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.local.datalist;

import java.io.File;
import java.io.IOException;
import utils.dataservice.gziplist.ChunkHeader;
import utils.dataservice.gziplist.ChunkList;
import utils.dataservice.gziplist.policies.CachePolicy;
import utils.dataservice.gziplist.policies.NullCachePolicy;
import utils.dataservice.gziplist.util.TypeCoverter;
import utils.dataservice.local.datalist.TimedList;

public class DoubleList
extends TimedList {
    public DoubleList(File file, ChunkList.EncryptionKeyRepository keyRepository, CachePolicy cachePolicy) throws IOException {
        super(file, DoubleList.getAggregators(), keyRepository, cachePolicy);
    }

    public DoubleList(File file, ChunkHeader header, ChunkList.EncryptionKeyRepository keyRepository, CachePolicy cachePolicy) throws IOException {
        super(file, DoubleList.getAggregators(), header, keyRepository, cachePolicy);
    }

    public DoubleList(File file, ChunkList.EncryptionKeyRepository keyRepository) throws IOException {
        super(file, DoubleList.getAggregators(), keyRepository, new NullCachePolicy());
    }

    public DoubleList(File file, ChunkHeader header, ChunkList.EncryptionKeyRepository keyRepository) throws IOException {
        super(file, DoubleList.getAggregators(), header, keyRepository, new NullCachePolicy());
    }

    public static byte[] getAggregators() {
        byte[] validAggregators = new byte[]{0, 1, 2, 3, 4};
        return validAggregators;
    }

    @Override
    public Class getDataClass() {
        return Double.class;
    }

    @Override
    public void initializeByteContainer() {
        this.byteContainer = new byte[16];
    }

    @Override
    public int writeEventData(Object object) throws Exception {
        Double d = (Double)object;
        TypeCoverter.doubleToByte(d, this.byteContainer, 8);
        return this.byteContainer.length;
    }

    @Override
    public Object parseEventValue(byte[] bytes) {
        return new Double(TypeCoverter.byteToDouble(bytes, 8));
    }

    public Double getDoubleValue(long index) {
        return (Double)this.getValue(index);
    }

    public void addDouble(double timestamp, Double doubleValue) {
        this.add(timestamp, doubleValue);
    }
}

