/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import utils.dataservice.gziplist.DataServiceRAFilePool;

public class RandomAccessInputStream
extends InputStream {
    File raFile;
    long markFp = 0L;

    public RandomAccessInputStream(File raFile) {
        this.raFile = raFile;
    }

    public long getMark() throws IOException {
        return this.markFp;
    }

    public void mark() throws IOException {
        this.markFp = DataServiceRAFilePool.getInstance().getFilePointer(this.raFile);
    }

    public void reset(long additional) throws IOException {
        DataServiceRAFilePool.getInstance().seek(this.raFile, this.markFp + additional);
    }

    @Override
    public int read() throws IOException {
        return DataServiceRAFilePool.getInstance().read(this.raFile);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return DataServiceRAFilePool.getInstance().read(this.raFile, b, off, len);
    }

    @Override
    public int available() throws IOException {
        return DataServiceRAFilePool.getInstance().available(this.raFile);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }
}

