/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.index;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.dataservice.gziplist.IndexHelper;
import utils.stream.StreamUtils;

public class IndexElement {
    private static long INDEX_ELEMENT_SIZE = 25L;
    protected long chunkIndex;
    protected long filePointerPosition;
    protected double startTime;
    protected double endTime;
    protected boolean isTemporary;

    public IndexElement(boolean isTemporary, long filePointerPosition, long chunkIndex, double startTime, double endTime) {
        this.isTemporary = isTemporary;
        this.chunkIndex = chunkIndex;
        this.filePointerPosition = filePointerPosition;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void setIsTemporary(boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    public static long getIndexElementSize() {
        return INDEX_ELEMENT_SIZE;
    }

    public void toStream(OutputStream outStream) throws IOException {
        StreamUtils.writeBoolean((OutputStream)outStream, (boolean)this.isTemporary);
        StreamUtils.writeLong((OutputStream)outStream, (long)this.filePointerPosition);
        StreamUtils.writeDouble((OutputStream)outStream, (double)this.startTime);
        StreamUtils.writeDouble((OutputStream)outStream, (double)this.endTime);
    }

    public static IndexElement fromStream(InputStream inStream, long chunkIndex) throws IOException {
        boolean isTemporary = StreamUtils.readBoolean((InputStream)inStream);
        long filePointerPosition = StreamUtils.readLong((InputStream)inStream);
        double startTime = StreamUtils.readDouble((InputStream)inStream);
        double endTime = StreamUtils.readDouble((InputStream)inStream);
        return new IndexElement(isTemporary, filePointerPosition, chunkIndex, startTime, endTime);
    }

    public int contains(long elementIndex) {
        long startIndex = IndexHelper.getChunkStartIndex(this.chunkIndex);
        long endIndex = IndexHelper.getChunkEndIndex(this.chunkIndex);
        if (startIndex <= elementIndex && endIndex > elementIndex) {
            return 0;
        }
        if (startIndex > elementIndex) {
            return 1;
        }
        return -1;
    }

    public long getFilePointerPosition() {
        return this.filePointerPosition;
    }

    public long getChunkIndex() {
        return this.chunkIndex;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (!IndexHelper.isAggregateChunk(this.chunkIndex)) {
            buffer.append("Index Element :  fp = ").append(this.filePointerPosition);
        } else {
            buffer.append("Aggregate Element : fp = ").append(this.filePointerPosition);
        }
        return buffer.toString();
    }
}

