/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist.aggregator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.AggregateChunk;
import utils.dataservice.gziplist.aggregator.Aggregator;
import utils.stream.StreamUtils;

public class EnumAggregator
extends Aggregator {
    long[] enumCount = new long[256];
    long[][][] sub_count;
    long count = 0L;

    protected EnumAggregator(int chunkSpan, boolean subAggregator) {
        super((byte)13, chunkSpan, subAggregator);
        this.initSubAggregator();
        this.reset();
    }

    private void initSubAggregator() {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            this.sub_count = new long[subLevels][][];
            for (int i = 0; i < subLevels; ++i) {
                int subEventSpan = AggregateChunk.SUB_EVENT_SPAN[i];
                int bucketCount = AggregateChunk.AGGREGATE_EVENT_SPANS[0] / subEventSpan;
                this.sub_count[i] = new long[bucketCount][256];
            }
        }
    }

    private void writeSubToStream(OutputStream outStream) throws IOException {
        if (this.subAggregator) {
            StreamUtils.writeLong((OutputStream)outStream, (long)this.count);
            int levels = this.sub_count.length;
            StreamUtils.writeShort((OutputStream)outStream, (short)levels);
            for (int i = 0; i < levels; ++i) {
                int subLevels = this.sub_count[i].length;
                StreamUtils.writeShort((OutputStream)outStream, (short)subLevels);
                for (int j = 0; j < subLevels; ++j) {
                    StreamUtils.writeLongArray((OutputStream)outStream, (long[])this.sub_count[i][j]);
                }
            }
        }
    }

    private void readSubFromStream(InputStream inStream) throws IOException {
        if (this.subAggregator) {
            this.count = StreamUtils.readLong((InputStream)inStream);
            int levels = StreamUtils.readShort((InputStream)inStream);
            for (int i = 0; i < levels; ++i) {
                int subLevels = StreamUtils.readShort((InputStream)inStream);
                for (int j = 0; j < subLevels; ++j) {
                    StreamUtils.readLongArray((InputStream)inStream, (long[])this.sub_count[i][j]);
                }
            }
        }
    }

    private void resetSubAggregator() {
        if (this.subAggregator) {
            this.count = 0L;
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                for (int j = 0; j < this.sub_count[i].length; ++j) {
                    Arrays.fill(this.sub_count[i][j], 0L);
                }
            }
        }
    }

    private void addSubAggregatorValue(Number number) {
        if (this.subAggregator) {
            int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
            for (int i = 0; i < subLevels; ++i) {
                int bucket = (int)(this.count / (long)AggregateChunk.SUB_EVENT_SPAN[i]);
                long[] lArray = this.sub_count[i][bucket];
                int n = number.intValue() & 0xFF;
                lArray[n] = lArray[n] + 1L;
            }
        }
    }

    private void addSubAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        int subLevels = AggregateChunk.SUB_EVENT_SPAN.length;
        for (int i = 0; i < subLevels; ++i) {
            if ((long)AggregateChunk.SUB_EVENT_SPAN[i] != eventSpan) continue;
            long subStartIndex = startIndex % (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0];
            int bucket = (int)(subStartIndex / eventSpan);
            for (int j = 0; j < 256; ++j) {
                int n = j;
                this.enumCount[n] = this.enumCount[n] + ((EnumAggregator)agg).sub_count[i][bucket][j];
            }
        }
    }

    @Override
    public Object getValue() {
        return this.enumCount;
    }

    @Override
    public void writeToStream(OutputStream outStream) throws IOException {
        StreamUtils.writeLongArray((OutputStream)outStream, (long[])this.enumCount);
        this.writeSubToStream(outStream);
    }

    @Override
    public void readFromStream(InputStream inStream) throws IOException {
        this.enumCount = StreamUtils.readLongArray((InputStream)inStream);
        this.readSubFromStream(inStream);
    }

    @Override
    public void reset() {
        Arrays.fill(this.enumCount, 0L);
        this.resetSubAggregator();
    }

    @Override
    public void addValue(double timestamp, Object object, double previousTimestamp, Object previousObject) {
        if (object instanceof Number) {
            Number number = (Number)object;
            this.addSubAggregatorValue(number);
            int n = number.intValue() & 0xFF;
            this.enumCount[n] = this.enumCount[n] + 1L;
        }
    }

    @Override
    public void addAggregateValue(Aggregator agg, long startIndex, long eventSpan) {
        if (agg instanceof EnumAggregator) {
            if (eventSpan < (long)AggregateChunk.AGGREGATE_EVENT_SPANS[0]) {
                this.addSubAggregateValue(agg, startIndex, eventSpan);
            } else {
                EnumAggregator maxAgg = (EnumAggregator)agg;
                for (int i = 0; i < 256; ++i) {
                    int n = i;
                    this.enumCount[n] = this.enumCount[n] + maxAgg.enumCount[i];
                }
            }
        }
    }
}

