/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import bcutil.BCUtil;
import bcutil.BCUtilOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import utils.dataservice.gziplist.Chunk;
import utils.dataservice.gziplist.DiskChunk;
import utils.encryption.gzip.FlushableGZIPOutputStream;
import utils.stream.StreamUtils;

public class MemoryChunk
extends Chunk {
    private byte[][] chunkData;
    private int shortestRecordLength = Integer.MAX_VALUE;
    private static final byte[] EMPTY = new byte[100];
    private static final boolean USE_BOUT_FOR_VARIABLE_SIZE_CHUNKS = true;
    protected double startTime;
    protected double endTime = -1.0;

    public MemoryChunk() {
        this.chunkData = new byte[EVENT_COUNT][];
        this.recordCount = 0;
    }

    public byte[] getRecord(long eventIndex) {
        return this.chunkData[(int)(eventIndex - this.getStartIndex())];
    }

    public void addRecord(double timestamp, byte[] record, int length) {
        if (this.recordCount == 0) {
            this.startTime = timestamp;
        }
        this.endTime = timestamp;
        this.chunkData[this.recordCount] = new byte[length];
        System.arraycopy(record, 0, this.chunkData[this.recordCount], 0, length);
        ++this.recordCount;
        if (length > this.maxRecordLength) {
            this.maxRecordLength = length;
        }
        if (length < this.shortestRecordLength) {
            this.shortestRecordLength = length;
        }
    }

    public void setRecord(int index, byte[] record, int length) {
        if (this.chunkData[index] == null || this.chunkData[index].length < length) {
            this.chunkData[index] = new byte[length];
        }
        System.arraycopy(record, 0, this.chunkData[index], 0, length);
        if (length > this.maxRecordLength) {
            this.maxRecordLength = length;
        }
        if (length < this.shortestRecordLength) {
            this.shortestRecordLength = length;
        }
    }

    @Override
    public void remove(long[] eventIndices) {
        Arrays.sort(eventIndices);
        int[] relativeIndices = new int[eventIndices.length];
        for (int i = 0; i < eventIndices.length; ++i) {
            long eventIndex = eventIndices[i];
            relativeIndices[i] = (int)(eventIndex - this.getStartIndex());
        }
        this.removeElementsFromChunkData(relativeIndices);
        this.recordCount -= relativeIndices.length;
    }

    private void removeElementsFromChunkData(int[] sortedOffsets) {
        int offsetIndex = 0;
        long offsetToWriteTo = -1L;
        while (offsetIndex < sortedOffsets.length) {
            long startOfValidData;
            long offsetToRemove = sortedOffsets[offsetIndex++];
            if (offsetToWriteTo == -1L) {
                offsetToWriteTo = offsetToRemove;
            }
            for (startOfValidData = offsetToRemove + 1L; offsetIndex < sortedOffsets.length && startOfValidData == (long)sortedOffsets[offsetIndex]; ++offsetIndex, ++startOfValidData) {
            }
            long nextOffsetToRemove = offsetIndex == sortedOffsets.length ? (long)this.chunkData.length : (long)sortedOffsets[offsetIndex];
            long endOfValidData = nextOffsetToRemove;
            if (endOfValidData - startOfValidData <= 0L) continue;
            System.arraycopy(this.chunkData, (int)startOfValidData, this.chunkData, (int)offsetToWriteTo, (int)(endOfValidData - startOfValidData));
            offsetToWriteTo += endOfValidData - startOfValidData;
        }
    }

    public boolean isFull() {
        return EVENT_COUNT == this.recordCount;
    }

    public boolean isEmpty() {
        return 0 == this.recordCount;
    }

    public void toStream(OutputStream outStream, BCUtil encryptUtil) throws IOException {
        boolean fixedSize;
        StreamUtils.writeInt((OutputStream)outStream, (int)this.recordCount);
        boolean bl = fixedSize = this.maxRecordLength == this.shortestRecordLength;
        if (!fixedSize) {
            StreamUtils.writeInt((OutputStream)outStream, (int)(this.maxRecordLength + 4));
        } else {
            StreamUtils.writeInt((OutputStream)outStream, (int)this.maxRecordLength);
        }
        if (fixedSize) {
            StreamUtils.writeBoolean((OutputStream)outStream, (boolean)true);
        } else {
            StreamUtils.writeBoolean((OutputStream)outStream, (boolean)false);
        }
        if (fixedSize) {
            FlushableGZIPOutputStream outputStream = encryptUtil == null ? new FlushableGZIPOutputStream(outStream) : new FlushableGZIPOutputStream((OutputStream)new BCUtilOutputStream(outStream, encryptUtil));
            for (int i = 0; i < this.recordCount; ++i) {
                outputStream.write(this.chunkData[i]);
            }
            outputStream.finish();
            outputStream.flush();
        } else {
            FlushableGZIPOutputStream gzipStream = encryptUtil == null ? new FlushableGZIPOutputStream(outStream) : new FlushableGZIPOutputStream((OutputStream)new BCUtilOutputStream(outStream, encryptUtil));
            BufferedOutputStream bout = new BufferedOutputStream(gzipStream);
            for (int i = 0; i < this.recordCount; ++i) {
                int mLength = this.maxRecordLength - this.chunkData[i].length;
                StreamUtils.writeBytes((OutputStream)bout, (byte[])this.chunkData[i]);
                int addedBytes = 0;
                while (addedBytes < mLength) {
                    if (mLength - addedBytes > 100) {
                        ((OutputStream)bout).write(EMPTY);
                        addedBytes += EMPTY.length;
                        continue;
                    }
                    ((OutputStream)bout).write(0);
                    ++addedBytes;
                }
            }
            ((OutputStream)bout).flush();
            gzipStream.finish();
            gzipStream.flush();
        }
    }

    public void resetMemoryChunk() {
        this.recordCount = 0;
        this.maxRecordLength = 0;
        this.shortestRecordLength = Integer.MAX_VALUE;
    }

    public void loadFrom(DiskChunk chunk, long chunkIndex) {
        this.resetMemoryChunk();
        this.setChunkIndex(chunkIndex);
        long startIndex = chunk.getStartIndex();
        long recCount = chunk.getRecordCount();
        for (long i = startIndex; i < startIndex + recCount; ++i) {
            byte[] event = chunk.getEvent(i);
            this.addRecord(0.0, event, event.length);
        }
    }

    @Override
    public boolean containsEvent(long eventIndex) {
        long startIndex = this.getStartIndex();
        return eventIndex >= startIndex && eventIndex < startIndex + (long)this.recordCount;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getStartTime() {
        return this.startTime;
    }
}

