/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import utils.dataservice.gziplist.Chunk;
import utils.stream.StreamUtils;

public class DiskChunk
extends Chunk {
    public byte[] payload;
    private boolean fixedSize = false;
    public int recordCount = 0;

    public static DiskChunk fromStream(InputStream inStream, long chunkIndex, BCUtil encryptUtil) throws IOException {
        DiskChunk chunk = new DiskChunk();
        chunk.recordCount = StreamUtils.readInt((InputStream)inStream);
        chunk.maxRecordLength = StreamUtils.readInt((InputStream)inStream);
        if (chunk.recordCount < 0 || chunk.maxRecordLength < 0 || chunk.recordCount > 100000) {
            throw new CorruptChunkException();
        }
        chunk.fixedSize = StreamUtils.readBoolean((InputStream)inStream);
        chunk.payload = new byte[chunk.recordCount * chunk.maxRecordLength];
        chunk.setChunkIndex(chunkIndex);
        GZIPInputStream in = encryptUtil == null ? new GZIPInputStream(inStream) : new GZIPInputStream((InputStream)new BCUtilInputStream(inStream, encryptUtil));
        int lastBytesRead = 0;
        for (int bytesDone = 0; bytesDone < chunk.payload.length && lastBytesRead != -1; bytesDone += lastBytesRead) {
            lastBytesRead = ((InputStream)in).read(chunk.payload, bytesDone, chunk.payload.length - bytesDone);
        }
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStream(OutputStream outStream, BCUtil encryptUtil) throws IOException {
        StreamUtils.writeInt((OutputStream)outStream, (int)this.recordCount);
        StreamUtils.writeInt((OutputStream)outStream, (int)this.maxRecordLength);
        StreamUtils.writeBoolean((OutputStream)outStream, (boolean)this.fixedSize);
        BufferedOutputStream outputStream = encryptUtil == null ? new BufferedOutputStream(new GZIPOutputStream(outStream)) : new BufferedOutputStream(new GZIPOutputStream((OutputStream)new BCUtilOutputStream(outStream, encryptUtil)));
        try {
            ((OutputStream)outputStream).write(this.payload);
        }
        finally {
            ((OutputStream)outputStream).flush();
        }
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    public byte[] getEvent(long eventIndex) {
        int eventStartPosition = (int)((eventIndex - this.getStartIndex()) * (long)this.maxRecordLength);
        if (!this.fixedSize) {
            try {
                ByteArrayInputStream inStream = new ByteArrayInputStream(this.payload, eventStartPosition, this.maxRecordLength);
                byte[] source = StreamUtils.readNBytes((InputStream)inStream, (int)(this.maxRecordLength * 2));
                inStream.close();
                return source;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        byte[] result = new byte[this.maxRecordLength];
        System.arraycopy(this.payload, eventStartPosition, result, 0, this.maxRecordLength);
        return result;
    }

    public long getSize() {
        return this.payload.length;
    }

    @Override
    public void remove(long[] eventIndices) {
        Arrays.sort(eventIndices);
        int[] relativeIndices = new int[eventIndices.length];
        for (int i = 0; i < eventIndices.length; ++i) {
            long eventIndex = eventIndices[i];
            relativeIndices[i] = (int)((eventIndex - this.getStartIndex()) * (long)this.maxRecordLength);
        }
        DiskChunk.removeDataFromByteArrayFast(relativeIndices, this.maxRecordLength, this.payload);
        this.recordCount -= relativeIndices.length;
    }

    private static void removeDataFromByteArrayFast(int[] sortedOffsets, int lengthOfEachElement, byte[] data) {
        int offsetIndex = 0;
        long offsetToWriteTo = -1L;
        while (offsetIndex < sortedOffsets.length) {
            long startOfValidData;
            long offsetToRemove = sortedOffsets[offsetIndex++];
            if (offsetToWriteTo == -1L) {
                offsetToWriteTo = offsetToRemove;
            }
            for (startOfValidData = offsetToRemove + (long)lengthOfEachElement; offsetIndex < sortedOffsets.length && startOfValidData == (long)sortedOffsets[offsetIndex]; ++offsetIndex, startOfValidData += (long)lengthOfEachElement) {
            }
            long nextOffsetToRemove = offsetIndex == sortedOffsets.length ? (long)data.length : (long)sortedOffsets[offsetIndex];
            long endOfValidData = nextOffsetToRemove;
            if (endOfValidData - startOfValidData <= 0L) continue;
            System.arraycopy(data, (int)startOfValidData, data, (int)offsetToWriteTo, (int)(endOfValidData - startOfValidData));
            offsetToWriteTo += endOfValidData - startOfValidData;
        }
        if (offsetToWriteTo < (long)data.length) {
            Arrays.fill(data, (int)offsetToWriteTo, data.length, (byte)0);
        }
    }

    public static class CorruptChunkException
    extends IOException {
    }
}

