/*
 * Decompiled with CFR 0.152.
 */
package utils.dataservice.gziplist;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChunkHeader {
    private int headerSizeBytes;
    private byte[] headerData;

    public ChunkHeader() {
        this.headerSizeBytes = 0;
    }

    public ChunkHeader(int headerSizeBytes) {
        this.headerSizeBytes = headerSizeBytes;
    }

    public ChunkHeader(byte[] data) {
        this(data.length);
        this.setHeaderData(data);
    }

    public void writeHeader(OutputStream out, BCUtil encryptUtil) throws IOException {
        DataOutputStream dout = encryptUtil != null ? new DataOutputStream((OutputStream)new BCUtilOutputStream(out, encryptUtil)) : new DataOutputStream(out);
        dout.writeInt(this.headerSizeBytes);
        if (this.headerData != null) {
            dout.write(this.headerData);
        } else {
            dout.write(new byte[0]);
        }
        dout.flush();
    }

    public void readHeader(InputStream in, BCUtil encryptUtil) throws IOException {
        DataInputStream din = encryptUtil == null ? new DataInputStream(in) : new DataInputStream((InputStream)new BCUtilInputStream(in, encryptUtil));
        this.headerSizeBytes = din.readInt();
        try {
            if (this.headerData == null || this.headerData.length != this.headerSizeBytes) {
                this.headerData = new byte[this.headerSizeBytes];
            }
        }
        catch (OutOfMemoryError error) {
            System.out.println("[ChunkHeader] Attempted to allocated " + this.headerSizeBytes);
            throw error;
        }
        din.read(this.headerData);
    }

    public void setHeaderData(byte[] header) {
        if (this.headerData == null || this.headerData.length != this.headerSizeBytes) {
            this.headerData = new byte[this.headerSizeBytes];
        }
        if (header != null) {
            System.arraycopy(header, 0, this.headerData, 0, Math.min(header.length, this.headerSizeBytes));
        }
    }

    public byte[] getHeaderData() {
        return this.headerData;
    }
}

