/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CertPolicyId;

public class PolicyMappings
extends ASN1Object {
    ASN1Sequence seq = null;

    public static PolicyMappings getInstance(Object obj) {
        if (obj instanceof PolicyMappings) {
            return (PolicyMappings)((Object)obj);
        }
        if (obj != null) {
            return new PolicyMappings(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    private PolicyMappings(ASN1Sequence seq) {
        this.seq = seq;
    }

    public PolicyMappings(Hashtable mappings) {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        Enumeration it = mappings.keys();
        while (it.hasMoreElements()) {
            String idp = (String)it.nextElement();
            String sdp = (String)mappings.get(idp);
            ASN1EncodableVector dv = new ASN1EncodableVector();
            dv.add((ASN1Encodable)new ASN1ObjectIdentifier(idp));
            dv.add((ASN1Encodable)new ASN1ObjectIdentifier(sdp));
            dev.add((ASN1Encodable)new DERSequence(dv));
        }
        this.seq = new DERSequence(dev);
    }

    public PolicyMappings(CertPolicyId issuerDomainPolicy, CertPolicyId subjectDomainPolicy) {
        ASN1EncodableVector dv = new ASN1EncodableVector();
        dv.add((ASN1Encodable)issuerDomainPolicy);
        dv.add((ASN1Encodable)subjectDomainPolicy);
        this.seq = new DERSequence((ASN1Encodable)new DERSequence(dv));
    }

    public PolicyMappings(CertPolicyId[] issuerDomainPolicy, CertPolicyId[] subjectDomainPolicy) {
        ASN1EncodableVector dev = new ASN1EncodableVector();
        for (int i = 0; i != issuerDomainPolicy.length; ++i) {
            ASN1EncodableVector dv = new ASN1EncodableVector();
            dv.add((ASN1Encodable)issuerDomainPolicy[i]);
            dv.add((ASN1Encodable)subjectDomainPolicy[i]);
            dev.add((ASN1Encodable)new DERSequence(dv));
        }
        this.seq = new DERSequence(dev);
    }

    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }
}

