/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x500.style;

class X500NameTokenizer {
    private String value;
    private int index;
    private char separator;
    private StringBuffer buf = new StringBuffer();

    public X500NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X500NameTokenizer(String oid, char separator) {
        this.value = oid;
        this.index = -1;
        this.separator = separator;
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        int end;
        if (this.index == this.value.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        for (end = this.index + 1; end != this.value.length(); ++end) {
            char c = this.value.charAt(end);
            if (c == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    if (c == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                        this.buf.append('\\');
                    } else if (c == '+' && this.separator != '+') {
                        this.buf.append('\\');
                    }
                    this.buf.append(c);
                }
                escaped = false;
                continue;
            }
            if (escaped || quoted) {
                if (c == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                    this.buf.append('\\');
                } else if (c == '+' && this.separator != '+') {
                    this.buf.append('\\');
                }
                this.buf.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == this.separator) break;
            this.buf.append(c);
        }
        this.index = end;
        return this.buf.toString().trim();
    }
}

