/*
 * Decompiled with CFR 0.152.
 */
package jpty.macosx;

import jpty.JPty;
import jpty.NativeMethods;
import jpty.Termios;
import jwrapper.jwutils.pty.WinSize;

public class JPtyImplMac
implements JPty.JPtyInterface {
    public JPtyImplMac() {
        JPty.ONLCR = 2;
        JPty.VERASE = 3;
        JPty.VWERASE = 4;
        JPty.VKILL = 5;
        JPty.VREPRINT = 6;
        JPty.VINTR = 8;
        JPty.VQUIT = 9;
        JPty.VSUSP = 10;
        JPty.ECHOKE = 1;
        JPty.ECHOCTL = 64;
    }

    @Override
    public int execve(String command, String[] argv, String[] env) {
        return NativeMethods.execve(command, argv, env);
    }

    @Override
    public int forkpty(int[] amaster, byte[] name, Termios term, WinSize win) {
        return NativeMethods.forkpty(amaster, name, null, null);
    }

    @Override
    public int getWinSize(int fd, WinSize winSize) {
        int r = NativeMethods.ioctlGetWinSize(fd, winSize);
        if (r < 0) {
            return r;
        }
        return r;
    }

    @Override
    public int kill(int pid, int signal) {
        return NativeMethods.kill(pid, signal);
    }

    @Override
    public int setWinSize(int fd, WinSize winSize) {
        return NativeMethods.ioctlSetWinSize(fd, winSize);
    }

    @Override
    public int waitpid(int pid, int[] stat, int options) {
        return NativeMethods.waitpid(pid, stat, options);
    }

    public static class winsize {
        public short ws_row;
        public short ws_col;
        public short ws_xpixel;
        public short ws_ypixel;

        public winsize() {
        }

        public winsize(WinSize ws) {
            this.ws_row = ws.ws_row;
            this.ws_col = ws.ws_col;
            this.ws_xpixel = ws.ws_xpixel;
            this.ws_ypixel = ws.ws_ypixel;
        }

        public void update(WinSize winSize) {
            winSize.ws_col = this.ws_col;
            winSize.ws_row = this.ws_row;
            winSize.ws_xpixel = this.ws_xpixel;
            winSize.ws_ypixel = this.ws_ypixel;
        }
    }
}

