/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPer {
    public static final GZIPer zipper = new GZIPer();

    public static byte[] s_compress(byte[] dat) throws IOException {
        return zipper.compress(dat);
    }

    public static byte[] s_compress(byte[] dat, int off, int len) throws IOException {
        return zipper.compress(dat, off, len);
    }

    public static byte[] s_decompress(byte[] dat) throws IOException {
        return zipper.decompress(dat);
    }

    public byte[] compress(byte[] dat) throws IOException {
        return this.compress(dat, 0, dat.length);
    }

    public byte[] compress(byte[] dat, int off, int len) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GZIPOutputStream gzout = new GZIPOutputStream(bout);
        gzout.write(dat, off, len);
        gzout.finish();
        gzout.close();
        return bout.toByteArray();
    }

    public byte[] decompress(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        GZIPInputStream gzin = new GZIPInputStream(bin);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = gzin.read(buf, 0, 1024);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }
}

