/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.sound;

import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SampledSound {
    public AudioFormat format;
    public byte[] data;
    public String name;

    public SampledSound(File file) throws IOException, UnsupportedAudioFileException {
        this.init(file);
    }

    private void init(File file) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        this.name = file.getName();
        this.format = audioInputStream.getFormat();
        this.data = StreamUtils.readAll(new BufferedInputStream(audioInputStream));
    }

    public SampledSound(String name, InputStream in) throws IOException, UnsupportedAudioFileException {
        this.name = name;
        this.init(in);
    }

    private void init(InputStream in) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(in);
        this.format = audioInputStream.getFormat();
        this.data = StreamUtils.readAll(new BufferedInputStream(audioInputStream));
    }

    public String getName() {
        return this.name;
    }
}

