/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.multiplex;

import com.aem.utils.StreamUtils;
import com.aem.utils.mutex.UnqueuedMutex;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import utils.stream.OpenByteArrayOutputStream;

public class MultiplexerOutputStream
implements com.aem.utils.multiplex.MultiplexingOutput {
    OutputStream outstream;
    private Object lock = new Object();
    HashMap streams = new HashMap();
    HashMap locks = new HashMap();
    IOException ioexception;
    private static final int MINCHUNK = 1024;
    private static final int MAXCHUNK = 4096;

    private void checkIoException(String err) throws IOException {
        if (this.ioexception != null) {
            IOException tmp = new IOException(err);
            tmp.initCause(this.ioexception);
            throw tmp;
        }
    }

    public MultiplexerOutputStream(OutputStream out) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name) {
        this.outstream = new BufferedOutputStream(out);
    }

    public MultiplexerOutputStream(OutputStream out, String name, ThreadGroup tg) {
        this.outstream = new BufferedOutputStream(out);
    }

    public void closeAll(IOException err) {
        this.ioexception = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnqueuedMutex getLock(short n) {
        Integer N = new Integer(n);
        Object object = this.lock;
        synchronized (object) {
            UnqueuedMutex nlock = (UnqueuedMutex)this.locks.get(N);
            if (nlock == null) {
                nlock = new UnqueuedMutex();
                this.locks.put(N, nlock);
            }
            return nlock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream(short n) {
        HashMap hashMap = this.streams;
        synchronized (hashMap) {
            Integer N = new Integer(n);
            OutputStream out = (OutputStream)this.streams.get(N);
            if (out == null) {
                out = new MultiplexingOutput(n);
                this.streams.put(N, out);
            }
            return out;
        }
    }

    @Override
    public void flushAll() throws IOException {
        Collection tmp = this.streams.values();
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            ((MultiplexingOutput)it.next()).flush();
        }
    }

    class MultiplexingOutput
    extends FilterOutputStream {
        short n;
        Object boutlock;
        OpenByteArrayOutputStream bout;

        public MultiplexingOutput(short n) {
            super(MultiplexerOutputStream.this.outstream);
            this.boutlock = new Object();
            this.bout = new OpenByteArrayOutputStream();
            this.n = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeChunk() throws IOException {
            Object object = MultiplexerOutputStream.this.lock;
            synchronized (object) {
                if (this.bout.size() > 0) {
                    StreamUtils.writeShort(MultiplexerOutputStream.this.outstream, this.n);
                    StreamUtils.writeBytes(MultiplexerOutputStream.this.outstream, this.bout.getByteArray(), 0, this.bout.size());
                    this.bout.reset();
                }
            }
        }

        @Override
        public void flush() throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error flushing output stream");
            this.writeChunk();
            MultiplexerOutputStream.this.outstream.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error writing to output stream");
            this.bout.write(b);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error writing to output stream");
            this.bout.write(b, off, len);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }

        @Override
        public void write(int b) throws IOException {
            MultiplexerOutputStream.this.checkIoException("Error writing to output stream");
            this.bout.write(b);
            if (this.bout.size() > 1024) {
                this.flush();
            }
        }
    }
}

