/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.keyhandling;

import com.aem.utils.keyhandling.Language;
import com.aem.utils.keyhandling.LanguageTable;
import java.util.HashMap;
import jwrapper.hidden.JWNativeAPI;
import utils.ostools.OS;

public class KeyboardLayout {
    private static final HashMap<String, String> layoutIDToDescription = new HashMap();

    public static String toHexLayoutID(long currentKeyboardLayout) {
        String s = Long.toHexString(currentKeyboardLayout);
        while (s.length() < 8) {
            s = "0" + s;
        }
        return s;
    }

    public static String toShortHexVariantLayoutID(long layout) {
        String s = Long.toHexString(layout);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return s;
    }

    public static String getKeyboardLayoutDescription() {
        if (OS.isWindows()) {
            String layoutID = JWNativeAPI.getInstance().getKeyboardLayoutName();
            return JWNativeAPI.getInstance().regGet("HKLM", "SYSTEM\\ControlSet001\\Control\\Keyboard Layouts\\" + layoutID, "Layout Text");
        }
        return "";
    }

    public static String getWindowsKeyboardLayoutDescription(long layoutID) {
        if (OS.isWindows()) {
            String description = KeyboardLayout.getDescriptionForID(KeyboardLayout.toHexLayoutID(layoutID));
            if (description != null) {
                return description;
            }
            long language = 0xFFFFL & layoutID;
            Language l = LanguageTable.getLanguageByID("0x" + KeyboardLayout.toShortHexVariantLayoutID(language));
            if (l != null) {
                String lang = l.languageName;
                if (l.location.length() == 0) {
                    return lang;
                }
                int index = lang.indexOf(41);
                if (index == -1) {
                    return lang + " (" + l.location + ")";
                }
                return lang.substring(0, index) + ", " + l.location + ")";
            }
            String id = KeyboardLayout.toHexLayoutID(language);
            return KeyboardLayout.getDescriptionForID(id);
        }
        return "";
    }

    private static String getDescriptionForID(String id) {
        if (layoutIDToDescription.size() == 0) {
            KeyboardLayout.populateLayoutIDMap();
        }
        if (id == null) {
            return "Unknown";
        }
        id = id.toUpperCase();
        return layoutIDToDescription.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateLayoutIDMap() {
        HashMap<String, String> hashMap = layoutIDToDescription;
        synchronized (hashMap) {
            String[] allLayouts;
            if (layoutIDToDescription.size() > 0) {
                return;
            }
            for (String s : allLayouts = JWNativeAPI.getInstance().regGetChildren("HKLM", "SYSTEM\\ControlSet001\\Control\\Keyboard Layouts")) {
                if (s.startsWith("----")) continue;
                String text = JWNativeAPI.getInstance().regGet("HKLM", "SYSTEM\\ControlSet001\\Control\\Keyboard Layouts\\" + s, "Layout Text");
                String layoutID = JWNativeAPI.getInstance().regGet("HKLM", "SYSTEM\\ControlSet001\\Control\\Keyboard Layouts\\" + s, "Layout Id");
                if (layoutID == null || layoutID.length() == 0) {
                    layoutIDToDescription.put(s.toUpperCase(), text);
                    continue;
                }
                String key = layoutID + s.substring(4);
                key = key.toUpperCase();
                layoutIDToDescription.put(key, text);
            }
            System.out.println("[MappingName] Initialised " + layoutIDToDescription.keySet().size() + " layouts");
        }
    }
}

