/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.crc;

import com.aem.utils.crc.CRC;
import com.aem.utils.crc.CRC64;
import com.aem.utils.crc.XOR;
import java.io.ByteArrayOutputStream;

public class CompoundCRC
extends CRC {
    CRC[] crcs;

    public CompoundCRC() {
        this(new CRC[]{new CRC64(), new XOR(64)});
    }

    public CompoundCRC(CRC[] crcs) {
        this.crcs = crcs;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.crcs.length; ++i) {
            this.crcs[i].reset();
        }
    }

    @Override
    public void add(byte b) {
        for (int i = 0; i < this.crcs.length; ++i) {
            this.crcs[i].add(b);
        }
    }

    @Override
    public byte[] getDigest() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        for (int i = 0; i < this.crcs.length; ++i) {
            byte[] tmp = this.crcs[i].getDigest();
            bout.write(tmp, 0, tmp.length);
        }
        return bout.toByteArray();
    }
}

