/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.com;

import com.aem.utils.NativeCOMUtil;
import com.aem.utils.com.Dispatch;
import java.util.ArrayList;

public class Variant {
    public long variantID;
    public static final short TYPE_EMPTY = 0;
    public static final short TYPE_NULL = 1;
    public static final short TYPE_SHORT = 2;
    public static final short TYPE_INTEGER = 3;
    public static final short TYPE_DATE = 7;
    public static final short TYPE_BOOLEAN = 11;
    public static final short TYPE_STRING = 8;
    private ArrayList<Dispatch> allDispatches = new ArrayList();

    public Variant() {
        this.variantID = NativeCOMUtil.getInstance().newVariant();
    }

    public short getVariantType() {
        return NativeCOMUtil.getInstance().getVariantType(this.variantID);
    }

    public void cleanup() {
        if (this.variantID != 0L) {
            NativeCOMUtil.getInstance().cleanupVariant(this.variantID);
        }
        for (Dispatch d : this.allDispatches) {
            d.cleanup();
        }
    }

    public Dispatch variantToDispatch() {
        Dispatch d = new Dispatch(NativeCOMUtil.getInstance().getVariantAsDispatch(this.variantID));
        this.allDispatches.add(d);
        return d;
    }

    public void set(String s) {
        NativeCOMUtil.getInstance().setVariantAsString(this.variantID, s);
    }

    public void set(int s) {
        NativeCOMUtil.getInstance().setVariantAsInteger(this.variantID, s);
    }

    public void set(short s) {
        NativeCOMUtil.getInstance().setVariantAsShort(this.variantID, s);
    }

    public void set(boolean s) {
        NativeCOMUtil.getInstance().setVariantAsBoolean(this.variantID, s);
    }

    public String getAsString() {
        switch (this.getVariantType()) {
            case 8: {
                return NativeCOMUtil.getInstance().getVariantAsString(this.variantID);
            }
            case 0: 
            case 1: {
                return null;
            }
        }
        throw new InvalidTypeException("Cannot convert type " + this.getVariantType() + " to String");
    }

    public long getAsDate() {
        if (this.getVariantType() == 7) {
            return NativeCOMUtil.getInstance().getVariantAsDate(this.variantID);
        }
        throw new InvalidTypeException("Cannot convert type " + this.getVariantType() + " to Date");
    }

    public int getAsInteger() {
        if (this.getVariantType() == 3) {
            return NativeCOMUtil.getInstance().getVariantAsInteger(this.variantID);
        }
        throw new InvalidTypeException("Cannot convert type " + this.getVariantType() + " to Integer");
    }

    public boolean getAsBoolean() {
        if (this.getVariantType() == 11) {
            return NativeCOMUtil.getInstance().getVariantAsBoolean(this.variantID);
        }
        throw new InvalidTypeException("Cannot convert type " + this.getVariantType() + " to Boolean");
    }

    public short getAsShort() {
        if (this.getVariantType() == 2) {
            return NativeCOMUtil.getInstance().getVariantAsShort(this.variantID);
        }
        throw new InvalidTypeException("Cannot convert type " + this.getVariantType() + " to Short");
    }

    public static Variant toVariant(Object newArg) {
        if (newArg instanceof String) {
            Variant v = new Variant();
            v.set((String)newArg);
            return v;
        }
        if (newArg instanceof Integer) {
            Variant v = new Variant();
            v.set((Integer)newArg);
            return v;
        }
        if (newArg instanceof Short) {
            Variant v = new Variant();
            v.set((Short)newArg);
            return v;
        }
        if (newArg instanceof Boolean) {
            Variant v = new Variant();
            v.set((Boolean)newArg);
            return v;
        }
        return null;
    }

    public class InvalidTypeException
    extends RuntimeException {
        public InvalidTypeException(String s) {
            super(s);
        }
    }
}

