/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import com.aem.sdesktop.util.Version;
import com.aem.sgateway.SGInstallationCheck;
import com.aem.shelp.common.TechLaunchAPI;
import com.aem.shelp.licence.OemBranding;
import com.aem.tests.OsRestore;
import com.aem.tests.TechLaunchUtility;
import com.aem.utils.ClassPathHacker;
import com.aem.utils.NullOutputStream;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.files.PathUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.osstats.WindowsStats;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.PrintingUtil;
import utils.progtools.ProcessPrinter;
import utils.progtools.time.Times;
import utils.string.CharStack;
import utils.string.Normaliser;
import utils.string.StringUtil;

public class SgSetupUtility {
    public static boolean LAUNCH_FROM_EXES = false;
    public static boolean LAUNCH_BOTH_METHODS = true;
    public static final String[] EMPTY_ARGS = new String[0];
    public static final int TYPE_INSTALL_NORMAL_MANUAL = 0;
    public static final int TYPE_INSTALL_PRECONFIGURED = 1;
    public static final int TYPE_INSTALL_MANUAL_DELETE = 2;
    public static final int TYPE_INSTALL_STOP_START_SERVICE_UPGRADE = 3;
    private static Object creds_LOCK = new Object();
    private static Properties creds = new Properties();
    static int T = 1;
    static int N = 1;
    static String testNum;
    static String attempt;
    static HashMap<String, String> raBuildToVersion;
    static OsRestore restore;

    private static String getPasswordFor(String server) throws IOException {
        if (creds.containsKey(server)) {
            return creds.getProperty(server);
        }
        File folder = new File(".");
        try {
            folder = JWSystem.getAllAppVersionsSharedFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File adminPassFile = new File(folder, "techTestServerPass_" + Normaliser.normaliseShort((String)server));
        String pass = adminPassFile.exists() ? SgSetupUtility.getInput("Admin pass for " + server, FileUtil.readFileAsStringUTF8((File)adminPassFile)) : SgSetupUtility.getInput("Admin pass for " + server, "");
        creds.setProperty(server, pass);
        FileUtil.writeFileAsStringUTF8((File)adminPassFile, (String)pass);
        return pass;
    }

    private static String getInput(String message, String initial) {
        return JOptionPane.showInputDialog(null, message, initial);
    }

    private static void haltForMessage(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    public static String getUrlHost(String baseurl) {
        try {
            return new URL(baseurl).getHost();
        }
        catch (IOException x) {
            return baseurl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testSgWorkingOk(String myprefix, String serverBaseURL) throws Exception {
        Stats.ProcessStatistic[] procs;
        long sgid;
        try {
            sgid = SGInstallationCheck.getSgID();
        }
        catch (IOException x) {
            x.printStackTrace();
            throw new Exception("Unable to get SG ID to even try a connection, SG is not installed correctly?");
        }
        JWSystem.clearPreparedFork();
        Thread.sleep(1000L);
        Stats stats = OsStats.getOsStats();
        HashMap<String, String> present = new HashMap<String, String>();
        stats.update();
        for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
            present.put(proc.id, proc.cmdLineArgs);
        }
        try {
            long sessionTimeout = 2L * Times.ONE_MINUTE;
            if (LAUNCH_BOTH_METHODS || LAUNCH_FROM_EXES) {
                TechLaunchUtility.launchSession(serverBaseURL, "SimpleHelpAdmin", SgSetupUtility.getPasswordFor(serverBaseURL), "SG_" + sgid, true);
            }
            if (LAUNCH_BOTH_METHODS || !LAUNCH_FROM_EXES) {
                TechLaunchAPI api = new TechLaunchAPI();
                api.setDirectMachine("SG_" + sgid);
                String pass = SgSetupUtility.getPasswordFor(serverBaseURL);
                api.setTechLogin(OemBranding.OEM_ADMIN_USERNAME, pass);
                System.out.println("[SgSetupUtility] Launching session via " + SgSetupUtility.getUrlHost(serverBaseURL));
                api.launch(serverBaseURL);
            }
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Launch session"));
            String match = "FTP Server version is";
            File logdir = JWSystem.getAllAppLoggingFolder();
            System.out.println("[SgSetupUtility] Logs dir is " + logdir);
            boolean success = false;
            long giveUp = System.currentTimeMillis() + sessionTimeout;
            System.out.println("[SgSetupUtility] Checking logs for " + sessionTimeout);
            block5: while (System.currentTimeMillis() < giveUp && !success) {
                Thread.sleep(3000L);
                File[] files = logdir.listFiles();
                for (File file : files) {
                    String name = file.getName();
                    if (name.indexOf("SessionUI") == -1) continue;
                    System.out.println("[SgSetupUtility] Session log file: " + name);
                    if (System.currentTimeMillis() - file.lastModified() >= 30000L) continue;
                    System.out.println("[SgSetupUtility] Searching recently modified log file " + name);
                    String contents = FileUtil.readFileAsString((File)file);
                    if (!contents.contains(match)) continue;
                    System.out.println("[SgSetupUtility] Session verified as SUCCESSFUL");
                    success = true;
                    continue block5;
                }
            }
            if (!success) {
                File techLogs = JWSystem.getAllAppLoggingFolder();
                JWTesting.reportStandaloneFail((String)(myprefix + " - Session via " + SgSetupUtility.getUrlHost(serverBaseURL) + " failed to connect - logs in " + techLogs));
                File raLogs = SgSetupUtility.getRaServiceLogFolder();
                File[] techFiles = techLogs.listFiles();
                File[] raFiles = raLogs.listFiles();
                File[] all = new File[techFiles.length + raFiles.length];
                System.arraycopy(techFiles, 0, all, 0, techFiles.length);
                System.arraycopy(raFiles, 0, all, techFiles.length, raFiles.length);
                File errorLogs = new File(techLogs, "RaUpgradeTestFailure_" + PrintingUtil.formatYMDHMSS((Date)new Date()));
                errorLogs.mkdirs();
                for (File file : all) {
                    if (file.getName().contains("RaUpgradeTestFailure")) continue;
                    FileUtil.copy((File)file, (File)new File(errorLogs, file.getName()));
                }
                throw new Exception("Failed to verify with successful session");
            }
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Session via " + SgSetupUtility.getUrlHost(serverBaseURL) + " connected OK"));
        }
        catch (Throwable throwable) {
            stats.update();
            Stats.ProcessStatistic[] testprocs = stats.getProcessStatistics();
            System.out.println("[SgSetupUtility] Terminating session process and any others launched during our test run");
            for (Stats.ProcessStatistic proc : testprocs) {
                if (present.containsKey(proc.id)) continue;
                System.out.println("New process: " + proc.id + ", " + proc.name + ", " + proc.cmdLineArgs);
                String info = proc.name.toLowerCase() + " " + proc.cmdLineArgs.toLowerCase();
                String[] killprocs = new String[]{"session", "tech", "access", "simplegateway", "osxwrapper", "osxlauncher"};
                boolean matches = false;
                for (String kill : killprocs) {
                    if (info.indexOf(kill.toLowerCase()) == -1) continue;
                    matches = true;
                    break;
                }
                if (!matches) continue;
                System.out.println("Terminating " + proc.id);
                OsStats.getOsStats().killProcess(proc.id);
            }
            throw throwable;
        }
        stats.update();
        Stats.ProcessStatistic[] testprocs = stats.getProcessStatistics();
        System.out.println("[SgSetupUtility] Terminating session process and any others launched during our test run");
        for (Stats.ProcessStatistic proc : testprocs) {
            if (present.containsKey(proc.id)) continue;
            System.out.println("New process: " + proc.id + ", " + proc.name + ", " + proc.cmdLineArgs);
            String info = proc.name.toLowerCase() + " " + proc.cmdLineArgs.toLowerCase();
            String[] killprocs = new String[]{"session", "tech", "access", "simplegateway", "osxwrapper", "osxlauncher"};
            boolean matches = false;
            for (String kill : killprocs) {
                if (info.indexOf(kill.toLowerCase()) == -1) continue;
                matches = true;
                break;
            }
            if (!matches) continue;
            System.out.println("Terminating " + proc.id);
            OsStats.getOsStats().killProcess(proc.id);
        }
    }

    private static void removeSgInstall(boolean tryNormalUninstall) throws Exception {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        tryNormalUninstall = false;
        if (tryNormalUninstall) {
            System.out.println("[SgSetupUtility] Trying to uninstall v4 service via cmdline normally");
            try {
                File exe;
                String bin;
                String path;
                if (OS.isWindows()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("\\")) {
                        path = path + "\\";
                    }
                    path = path + "Remote AccessWinLauncher.exe";
                    SgSetupUtility.platformRun(new File(path), new String[]{"uninstall"});
                } else if (OS.isLinux()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    if (!new File(bin = path + "Remote AccessLinLauncher").exists()) {
                        bin = path + "Remote AccessLinLauncher64";
                    }
                    exe = new File(bin);
                    SgSetupUtility.platformRun(exe, new String[]{"uninstall"});
                } else if (OS.isMacOS()) {
                    path = master.getCanonicalPath();
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    bin = path + "JWAppsSharedConfig/SimpleGatewayService/SimpleGatewayService.app";
                    exe = new File(bin);
                    SgSetupUtility.platformRun(exe, new String[]{"uninstall"});
                }
            }
            catch (IOException x) {
                System.out.println("[SgSetupUtility] Unable to run uninstaller: " + x);
            }
            if (master.exists()) {
                System.out.println("[SgSetupUtility] WARNING ran SG uninstall but master folder still exists");
            }
        }
        if (master.exists()) {
            Stats.ProcessStatistic[] procs;
            System.out.println("[SgSetupUtility] Master folder exists, uninstall either didn't work or wasn't run, will force terminate and delete master folder");
            Stats stats = OsStats.getOsStats();
            stats.update();
            for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
                System.out.println("[SgSetupUtility] Process: " + proc.name + " " + proc.id + " " + proc.cmdLineArgs);
                String lc = proc.cmdLineArgs.toLowerCase();
                if (!lc.contains("remote access") && !lc.contains("simpleservice") && !lc.contains("simplegateway") && !lc.contains("jucheck") && !lc.contains("jusched") && !lc.contains("-online.exe") && !lc.contains("-offline.exe") && !lc.contains("cmd.exe")) continue;
                System.out.println("[SgSetupUtility] Terminating " + proc.name + " " + proc.id);
                JWGenericOS.getInstance();
                if (JWGenericOS.terminateProcess((int)Integer.parseInt(proc.id))) continue;
                System.out.println("[SgSetupUtility] WARNING unable to terminate process " + proc.id);
                RunCommandGetOutput.runCommandIgnoreOutput((String)("taskkill.exe /PID " + proc.id + " /F"));
            }
            try {
                System.out.println("[SgSetupUtility] Forcibly terminating any remaining v4 services");
                SGInstallationCheck.forceKillAllV4Services();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (OS.isWindows()) {
                try {
                    System.out.println("[SgSetupUtility] Sleeping to let windows catch up");
                    Thread.sleep(10000L);
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            System.out.println("[SgSetupUtility] Forcibly deleting the v4 service folder");
            SGInstallationCheck.forceDeleteV4ServiceFolder();
            if (master.exists()) {
                System.out.println("[SgSetupUtility] ERROR ran SG force delete but master folder still exists");
                stats = OsStats.getOsStats();
                stats.update();
                for (Stats.ProcessStatistic proc : procs = stats.getProcessStatistics()) {
                    System.out.println("[SgSetupUtility] Process: " + proc.name + " " + proc.id);
                }
                throw new Exception("Tried to forcibly terminate and delete SG but master folder still exists");
            }
        }
    }

    public static File platformExtract(File archive) throws IOException {
        if (OS.isWindows()) {
            return archive;
        }
        if (OS.isMacOS()) {
            String[] lines;
            RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand((String[])new String[]{"hdiutil", "attach", archive.getCanonicalPath()});
            if (response.returnCode != 0) {
                System.out.println("hdiutil output:\n" + response.stdout);
                System.out.println("hdiutil errors:\n" + response.stderr);
                throw new IOException("hdiutil returned non-zero return code");
            }
            String diskPath = null;
            String volumePath = null;
            for (String line : lines = response.stdout.trim().split("\n")) {
                System.out.println("Line: " + line);
                int maxIndex = Math.max(line.indexOf(" /"), line.indexOf("\t/"));
                if (maxIndex == -1) continue;
                volumePath = line.substring(++maxIndex).trim();
                diskPath = new CharStack(line).popText(true);
            }
            if (volumePath == null) {
                System.out.println("hdiutil output:\n" + response.stdout);
                System.out.println("hdiutil errors:\n" + response.stderr);
                throw new IOException("unable to get volume path from hdiutil output");
            }
            if (volumePath.endsWith("/")) {
                volumePath = volumePath.substring(0, volumePath.length() - 1);
            }
            File target = PathUtil.replaceSuffix((File)archive, (String)".app");
            File volume = new File(volumePath);
            File[] files = volume.listFiles();
            if (files == null) {
                throw new IOException("Unable to list volume provided by hdiutil " + volumePath);
            }
            File source = null;
            for (File file : files) {
                if (!file.getName().endsWith(".app")) continue;
                source = file;
            }
            if (source == null) {
                throw new IOException("Couldn't find .app file in volume provided by hdiutil " + volumePath);
            }
            System.out.println("Copying " + source + " to " + target);
            FileUtil.deleteDir((File)target);
            System.out.println("Deleting " + target);
            if (target.exists()) {
                System.out.println("ERROR unable to delete " + target);
            }
            RunCommandGetOutput.runCommand((String[])new String[]{"cp", "-r", source.getCanonicalPath(), target.getCanonicalPath()});
            System.out.println("Copying finished");
            System.out.println("chmodding " + target);
            RunCommandGetOutput.runCommand((String[])new String[]{"chmod", "777", target.getCanonicalPath()});
            RunCommandGetOutput.runCommandNoWait((String[])new String[]{"hdiutil", "detach", diskPath});
            return target;
        }
        System.out.println("Extracting tar archive");
        RunCommandGetOutput.runCommand((String[])new String[]{"tar", "-xf", archive.getCanonicalPath()});
        File extracted = new File(archive.getParentFile(), "Remote Access-" + PathUtil.replaceSuffix((File)archive, (String)"").getName());
        System.out.println("chmodding " + extracted);
        RunCommandGetOutput.runCommand((String[])new String[]{"chmod", "777", extracted.getCanonicalPath()});
        return extracted;
    }

    private static RunCommandGetOutput.CommandResponse platformRun(File app, String[] args) throws IOException {
        return SgSetupUtility.platformRun(app, args, true);
    }

    private static RunCommandGetOutput.CommandResponse platformRun(File app, String[] args, boolean wait) throws IOException {
        System.out.println("[PlatformRun] Original: " + app);
        app = SgSetupUtility.convertToExe(app);
        System.out.println("[PlatformRun] Converted: " + app);
        String[] cmd = new String[args.length + 1];
        cmd[0] = app.getCanonicalPath();
        System.arraycopy(args, 0, cmd, 1, args.length);
        for (String param : cmd) {
            System.out.println("[PlatformRun] Cmd: " + param);
        }
        if (!wait) {
            Process p = Runtime.getRuntime().exec(cmd, null, app.getParentFile());
            p.getOutputStream().close();
            new ProcessPrinter(p, (OutputStream)new NullOutputStream(), (OutputStream)new NullOutputStream());
            return null;
        }
        RunCommandGetOutput.CommandResponse response = RunCommandGetOutput.runCommand((String[])cmd, (File)app.getParentFile());
        System.out.println("[PlatformRun] Retcode: " + response.returnCode);
        if (response.returnCode != 0) {
            System.out.println("[PlatformRun] Stdout: " + response.stdout);
            System.out.println("[PlatformRun] Stderr: " + response.stderr);
        }
        return response;
    }

    private static File convertToExe(File app) {
        if (OS.isMacOS()) {
            String name = app.getName();
            if (name.endsWith("osxwrapper")) {
                return app;
            }
            if (!name.endsWith(".app")) {
                app = new File(app.getAbsolutePath() + ".app");
            }
            return new File(new File(new File(app, "Contents"), "MacOS"), "osxwrapper");
        }
        return app;
    }

    public static File getRaServiceLogFolder() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File logs = new File(master, "logs");
        return logs;
    }

    public static String getRaServiceVersion() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File logs = new File(master, "logs");
        Object[] files = logs.listFiles();
        if (files == null) {
            return "NONE";
        }
        Arrays.sort(files);
        Object target = null;
        for (Object file : files) {
            if (!((File)file).getName().contains("Remote Access Service")) continue;
            target = file;
        }
        CharStack cs = new CharStack(FileUtil.readFileAsStringUTF8(target));
        cs.popUntil("App Bundle Version:");
        String build = cs.popLine(true).trim();
        try {
            build = "" + Long.parseLong(build);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Version: " + build + ", from " + target);
        String version = raBuildToVersion.get(build);
        if (version != null) {
            return version;
        }
        return build;
    }

    public static File getServiceXmlConfig() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File config = new File(master, "JWAppsSharedConfig");
        File xml = new File(config, "serviceconfig.xml");
        return xml;
    }

    public static File getServiceIdFile() throws IOException {
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        File config = new File(master, "JWAppsSharedConfig");
        File xml = new File(config, "serviceid.dat");
        return xml;
    }

    private static void resetServiceServerURL(String targetURL) throws IOException {
        File xml = SgSetupUtility.getServiceXmlConfig();
        String utf8 = FileUtil.readFileAsStringUTF8((File)xml);
        String[] lines = utf8.split("\n");
        boolean added = false;
        ArrayList<String> results = new ArrayList<String>();
        for (String line : lines) {
            if (line.indexOf("<ConnectTo") == -1) {
                results.add(line);
                continue;
            }
            results.add("<ConnectTo>" + targetURL + "</ConnectTo>");
            added = true;
        }
        StringBuffer sb = new StringBuffer();
        for (String line : results) {
            sb.append(line).append("\n");
        }
        FileUtil.writeFileAsStringUTF8((File)xml, (String)sb.toString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 || !JWLaunchProperties.isJWrapperSetup()) {
            System.out.println("WARNING THIS MODE IS NO LONGER IN SERVICE");
            System.exit(0);
        } else {
            try {
                JWTesting.reportStandaloneSuccess((String)"SgSetupUtility launched OK");
                SgSetupUtility.runSgUpgradeTestBattery();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private static String getVersion(String server) {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        server = server + "version";
        try {
            URL url = new URL(server);
            System.out.println("Querying for version " + url);
            InputStream in = url.openStream();
            String version = utils.stream.StreamUtils.readAllAsString((InputStream)in);
            in.close();
            if (version.indexOf("SSuite-") == -1) {
                throw new Exception("Not a valid SH server");
            }
            return version.trim();
        }
        catch (Exception x) {
            return null;
        }
    }

    static void nextAttempt(String name) {
        testNum = "T" + T++;
        attempt = testNum + " - " + name;
        N = 1;
        JWTesting.reportAttempt((String)attempt, (String)"", (int)600000);
    }

    static void resetPart() {
        N = 1;
    }

    static String nextPart() {
        return testNum + "." + (++N - 1);
    }

    static void success() {
        JWTesting.reportSuccess((String)attempt);
    }

    static void failure(Throwable x) {
        JWTesting.reportStandaloneFail((String)attempt, (Throwable)x);
    }

    private static void populateBuildToVersion(String server) throws IOException {
        if (!server.endsWith("/")) {
            server = server + "/";
        }
        server = server + "allversions";
        URL url = new URL(server);
        InputStream in = url.openStream();
        String content = StreamUtils.readAllAsStringUTF8(in);
        CharStack cs = new CharStack(content);
        cs.popUntil("SSuite-");
        String major = cs.popUntil('-', true);
        String minor = cs.popUntil('-', true);
        cs.popUntil("Access Version:");
        String build = "" + (long)cs.popNumber(true);
        System.out.println("[SgSetupUtility] Mapping build " + build + " to version " + major + minor);
        raBuildToVersion.put(build, major + "." + minor);
    }

    private static ArrayList<String> discoverTestURLs(String targetServerURL) {
        String build = SgSetupUtility.getVersion(targetServerURL);
        JWTesting.reportStandaloneSuccess((String)("Target is " + build));
        ArrayList<String> testurls = new ArrayList<String>();
        StringBuffer details = new StringBuffer();
        boolean foundValid = false;
        for (int i = 44; i <= 99; ++i) {
            String test;
            String otherBuild;
            if (i == 45) {
                i = 50;
            }
            if ((otherBuild = SgSetupUtility.getVersion(test = "http://sh" + i + ".simplehelp.io")) == null && foundValid) break;
            JWTesting.reportStandaloneSuccess((String)("Verified " + test));
            JWTesting.reportStandaloneSuccess((String)("Version is " + otherBuild));
            if (Version.isBuildSameOrNewer(build, otherBuild)) break;
            testurls.add(test);
            System.out.println("Will test: " + test + " " + otherBuild + " < " + build);
            details.append("Will test: " + test + " " + otherBuild + " < " + build + "\n");
            foundValid = true;
        }
        return testurls;
    }

    private static void loadTechLaunchAPI(String targetServerURL) {
        try {
            String apijar = StringUtil.ensureTrailing((String)targetServerURL, (String)"/") + "technician/SimpleHelp%20Technician-java-online.jar";
            URL url = new URL(apijar);
            System.out.println("Attempting to download cmd API jar from " + url);
            InputStream in = url.openStream();
            byte[] dat = StreamUtils.readAll(in);
            File jar = new File("techapi.jar");
            FileUtil.writeFile((File)jar, (byte[])dat);
            ClassPathHacker.addFile(jar);
            JWTesting.reportStandaloneSuccess((String)"Successfully loaded cmdline API jar");
        }
        catch (IOException x) {
            x.printStackTrace();
            JWTesting.reportStandaloneFail((String)"Unable to load cmdline API jar", (Throwable)x);
        }
    }

    private static void runSgUpgradeTestBattery() {
        String target = JWLaunchProperties.getProperty((String)"update_url");
        String mypass = JWLaunchProperties.getProperty((String)"password");
        String[] excludes = new String[]{JWLaunchProperties.getProperty((String)"TEST_PARENT_PID"), JWTesting.getMyPid()};
        try {
            System.out.println("[SgSetupUtility] Terminating any existing tech sessions that might get in the way...");
            new WindowsStats(true, true).killProcessLaunchedFrom(JWSystem.getAllAppLoggingFolder().getParentFile().getCanonicalFile().getAbsolutePath(), excludes);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        restore = new OsRestore();
        SgSetupUtility.loadTechLaunchAPI(target);
        ArrayList<String> testurls = SgSetupUtility.discoverTestURLs(target);
        try {
            SgSetupUtility.getPasswordFor(target);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        for (String testurl : testurls) {
            try {
                SgSetupUtility.getPasswordFor(testurl);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        JWTesting.reportStandaloneSuccess((String)("Got test servers x" + testurls.size()), (String)"");
        System.out.println("[SgSetupUtility] Grabbing RA build versions from each server and mapping them to SH major/minor versions");
        try {
            SgSetupUtility.populateBuildToVersion(target);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        for (String testurl : testurls) {
            try {
                SgSetupUtility.populateBuildToVersion(testurl);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
        String name = "SgSetupUtilityAutotest";
        boolean ONLINE = true;
        boolean OFFLINE = false;
        ArrayList<RaAction> actions = new ArrayList<RaAction>();
        actions.clear();
        actions.add(new RaAction(ActionType.UNINSTALL_OR_DELETE));
        actions.add(new RaAction(ActionType.DOWNLOAD_ONLINE_RUN_SILENT, target, target));
        SgSetupUtility.runActionSet(actions, "Current online version from clean");
        actions.clear();
        actions.add(new RaAction(ActionType.UNINSTALL_OR_DELETE));
        actions.add(new RaAction(ActionType.DOWNLOAD_OFFLINE_RUN_SILENT, target, target));
        SgSetupUtility.runActionSet(actions, "Current offline version from clean");
        actions.clear();
        actions.add(new RaAction(ActionType.FORCED_DELETE));
        actions.add(new RaAction(ActionType.DOWNLOAD_ONLINE_RUN_SILENT, target, target));
        SgSetupUtility.runActionSet(actions, "Current online version from clean (forced)");
        actions.clear();
        actions.add(new RaAction(ActionType.FORCED_DELETE));
        actions.add(new RaAction(ActionType.DOWNLOAD_OFFLINE_RUN_SILENT, target, target));
        SgSetupUtility.runActionSet(actions, "Current offline version from clean (forced)");
        String tname = SgSetupUtility.getUrlHost(target);
        for (String oldserver : testurls) {
            String oldname = SgSetupUtility.getUrlHost(oldserver);
            actions.clear();
            actions.add(new RaAction(ActionType.UNINSTALL_OR_DELETE));
            actions.add(new RaAction(ActionType.DOWNLOAD_OFFLINE_RUN_SILENT, oldserver, target));
            SgSetupUtility.runActionSet(actions, "Connect to " + oldname + " via current");
            actions.clear();
            actions.add(new RaAction(ActionType.UNINSTALL_OR_DELETE));
            actions.add(new RaAction(ActionType.DOWNLOAD_OFFLINE_RUN_SILENT, target, oldserver));
            SgSetupUtility.runActionSet(actions, "Connect to current via " + oldname);
        }
        JWTesting.reportStandaloneSuccess((String)"All tests completed");
    }

    static void runActionSet(ArrayList<RaAction> actions, String testName) {
        SgSetupUtility.nextAttempt(testName);
        for (int i = 0; i < 3; ++i) {
            restore.restoreAll();
            try {
                SgSetupUtility.resetPart();
                for (RaAction action : actions) {
                    action.run();
                }
                SgSetupUtility.success();
                return;
            }
            catch (Throwable x) {
                SgSetupUtility.failure(x);
                continue;
            }
        }
    }

    public static void doAction(ActionType action, String downloadServerURL, String sessionServerURL) throws Exception {
        boolean preReported = false;
        String serviceName = "SgSetupUtilityTestService";
        String myprefix = SgSetupUtility.nextPart();
        String myrole = myprefix + " - " + action;
        JWTesting.reportAttempt((String)myrole, (String)("Download Server: " + downloadServerURL + "\nSession Server: " + sessionServerURL), (int)600000);
        if (OS.isMacOS() ? !JWMacOS.haveSudoPermissions() : OS.isLinux() && !JWLinuxOS.haveSudoPermissions()) {
            throw new Exception("SgSetupUtility MUST be run as ROOT");
        }
        File master = SGInstallationCheck.getStandardSgMasterFolder();
        System.out.println("[SgSetupUtility] Master folder is " + master + " (exists=" + master.exists() + ")");
        if (downloadServerURL != null) {
            System.out.println("[SgSetupUtility] Download Server URL: " + downloadServerURL);
            if (!downloadServerURL.endsWith("/")) {
                downloadServerURL = downloadServerURL + "/";
            }
        }
        if (sessionServerURL != null) {
            System.out.println("[SgSetupUtility] SH Server URL: " + sessionServerURL);
        }
        System.out.println("[SgSetupUtility] Action: " + action);
        boolean online = action == ActionType.DOWNLOAD_ONLINE_RUN_SILENT;
        String platform = OS.isMacOS() ? (online ? "macos64-online.dmg" : "macos64-offline.dmg") : (OS.isLinux64bit() ? (online ? "linux64-online.tar" : "linux64-offline.tar") : (OS.isLinux() ? (online ? "linux32-online.tar" : "linux32-offline.tar") : (OS.isWindowsXpOr2003() ? (online ? "windows32-online.exe" : "windows32-offline.exe") : (online ? "windows64-online.exe" : "windows64-offline.exe"))));
        if (action == ActionType.UNINSTALL_OR_DELETE) {
            System.out.println("[SgSetupUtility] Attempting to uninstall RA, will delete if necessary");
            SgSetupUtility.removeSgInstall(true);
        } else if (action == ActionType.FORCED_DELETE) {
            System.out.println("[SgSetupUtility] Attempting forced deletion of RA folder");
            SgSetupUtility.removeSgInstall(false);
        } else if (action == ActionType.STOP_START_SERVICE) {
            System.out.println("[SgSetupUtility] Stop-starting service to trigger upgrade");
            File stopper = new File(new File(master, serviceName), serviceName + "Stop.app");
            File starter = new File(new File(master, serviceName), serviceName + ".app");
            System.out.println("Stopping service...");
            SgSetupUtility.platformRun(stopper, EMPTY_ARGS);
            System.out.println("Starting service...");
            SgSetupUtility.platformRun(starter, EMPTY_ARGS);
        } else if (action == ActionType.DOWNLOAD_ONLINE_RUN_SILENT || action == ActionType.DOWNLOAD_OFFLINE_RUN_SILENT) {
            System.out.println("[SgSetupUtility] Downloading service from dl server URL and pointing at target server URL");
            String download = downloadServerURL + "access/Remote%20Access-" + platform + "?language=en&hostname=" + URLEncoder.encode(downloadServerURL);
            download = download + "&name=" + serviceName + "&silent=yes&servers=" + URLEncoder.encode(downloadServerURL);
            boolean popupHelp = false;
            URL downloadURL = new URL(download);
            System.out.println("[SgSetupUtility] Downloading from " + downloadURL);
            BufferedInputStream bin = new BufferedInputStream(downloadURL.openStream());
            byte[] dat = StreamUtils.readAll(bin);
            System.out.println("[SgSetupUtility] Read " + dat.length + " bytes");
            File output = new File(platform);
            output.delete();
            if (output.exists()) {
                System.out.println("[SgSetupUtility] ERROR unable to delete archive ready for download");
            }
            FileUtil.writeFile((File)output, (byte[])dat);
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Download RA service from " + downloadURL.getHost()));
            System.out.println("[SgSetupUtility] Downloaded to file " + output);
            System.out.println("[SgSetupUtility] Absolute path " + output.getAbsolutePath());
            File extracted = SgSetupUtility.platformExtract(output);
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Extracted RA service"));
            SgSetupUtility.platformRun(extracted, EMPTY_ARGS);
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Launched RA app"));
            File xml = SgSetupUtility.getServiceXmlConfig();
            File iddat = SgSetupUtility.getServiceIdFile();
            long giveup = System.currentTimeMillis() + 300000L;
            while (!xml.exists() || !iddat.exists()) {
                System.out.println("[SgSetupUtility] Waiting for SG XML config and SGID file to appear...");
                Thread.sleep(1000L);
                if (System.currentTimeMillis() <= giveup) continue;
                throw new IOException("SG XML file or SGID didn't appear (xml=" + xml.exists() + ") (iddat=" + iddat.exists() + ")");
            }
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - RA config file is ready"));
            if (!downloadServerURL.equals(sessionServerURL)) {
                Thread.sleep(5000L);
                System.out.println("[SgSetupUtility] Overwriting config server URL to " + sessionServerURL);
                SgSetupUtility.resetServiceServerURL(sessionServerURL);
            }
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - RA build is " + SgSetupUtility.getRaServiceVersion()));
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - RA configured to " + sessionServerURL));
            for (int i = 10; i > 0; --i) {
                System.out.println("[SgSetupUtility] Launching session in " + i + "...");
                Thread.sleep(1000L);
            }
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Session to RA service via " + SgSetupUtility.getUrlHost(sessionServerURL)));
            System.out.println("[SgSetupUtility] Launching session via " + sessionServerURL);
            SgSetupUtility.testSgWorkingOk(myprefix, sessionServerURL);
            JWTesting.reportStandaloneSuccess((String)(myprefix + " - Verified session to " + SgSetupUtility.getRaServiceVersion() + " via " + SgSetupUtility.getUrlHost(sessionServerURL)));
        }
        JWTesting.reportSuccess((String)myrole);
    }

    static {
        raBuildToVersion = new HashMap();
    }

    static class RaAction {
        ActionType type;
        String downloadServerURL;
        String sessionServerURL;

        public RaAction(ActionType type) {
            this.type = type;
        }

        public RaAction(ActionType type, String downloadServerURL, String sessionServerURL) {
            this.type = type;
            this.downloadServerURL = downloadServerURL;
            this.sessionServerURL = sessionServerURL;
        }

        public void run() throws Exception {
            SgSetupUtility.doAction(this.type, this.downloadServerURL, this.sessionServerURL);
        }
    }

    static class ActionType {
        String name;
        static final ActionType DOWNLOAD_ONLINE_RUN_SILENT = new ActionType("Download and install the online RA service");
        static final ActionType DOWNLOAD_OFFLINE_RUN_SILENT = new ActionType("Download and install the offline RA service");
        static final ActionType STOP_START_SERVICE = new ActionType("Stop Start RA service (to ensure it is properly upgraded)");
        static final ActionType UNINSTALL_OR_DELETE = new ActionType("Uninstall First (delete if necessary)");
        static final ActionType FORCED_DELETE = new ActionType("Forced deletion (no uninstall attempted)");

        public ActionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

