/*
 * Decompiled with CFR 0.152.
 */
package com.aem.tests;

import bcutil.BCUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.utils.WorkingNioSocket;
import com.aem.sdesktop.util.Version;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.sgateway.SimpleGatewayService;
import com.aem.shelp.common.PC;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyMessageHandler;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.LossyUtils;
import com.aem.shelp.mdupload.SecMsgDecryptionError;
import com.aem.shelp.mdupload.SecureMessenger;
import com.aem.shelp.mdupload.SecureMessengerDB;
import com.aem.shelp.mdupload.SecureMessengerListener;
import com.aem.shelp.mdupload.transports.HttpClientLossyTransport;
import com.aem.shelp.mdupload.transports.UdpClientLossyTransport;
import com.aem.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.Cache;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.net.URLParser;
import utils.stream.SelectPool;
import utils.stream.SelectPoolHandler;
import utils.string.HexData;
import utils.udp.bidirectional.UDPResponder;

public class AccessLoad {
    static int MAX_HTTP_RETURNED_DATA_SIZE = 5000000;
    static boolean VERBOSE_LOSSY = false;
    static boolean VERBOSE_CLAIM = false;
    static int POLL_RESPONSE_THREADS = 250;
    static int HANDSHAKE_THREADS = 1600;
    static Object handshake_LOCK = new Object();
    static Random random = new Random();
    static String serverHttp;
    static String serverHost;
    static int serverPort;
    static boolean isMonitoring;
    static String pkHashPortion;
    static String accessVersion;
    static Object seen_LOCK;
    static Cache<Integer, Integer> seen;
    static Object sims_LOCK;
    static ArrayList<ThinSgSimulation> sims;
    static SelectPool pollSelect;
    static Object startup_LOCK;
    static MaintenanceRunner maintenance;
    static OnDemandThreadPool simlaunch;

    public static void main(String[] args) throws IOException {
        AccessLoad.startup("http://localhost:8008");
        for (int i = 0; i < 2310; ++i) {
            AccessLoad.addSim(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String serverHttpAddress) throws IOException {
        Object object = startup_LOCK;
        synchronized (object) {
            if (maintenance != null) {
                return;
            }
            CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT = false;
            File secmsgs = new File("AccessLoad_SecMsgDB");
            SecureMessengerDB.noMergeDuplicateTargets();
            SecureMessengerDB.setDatabaseFolder(secmsgs, null, 1000000);
            serverHttp = serverHttpAddress;
            if (!serverHttp.endsWith("/")) {
                serverHttp = serverHttp + "/";
            }
            URLParser parser = new URLParser(serverHttp);
            serverHost = parser.getHostname();
            serverPort = parser.getPort(true);
            try {
                URL url = new URL(serverHttp + "access/JWrapper-Remote Access-version.txt");
                accessVersion = StreamUtils.readAllAsStringUTF8(url.openStream());
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            pollSelect = new SelectPool("Poll Response", new PollHandler(), POLL_RESPONSE_THREADS);
            maintenance = new MaintenanceRunner();
            maintenance.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSim(boolean https) {
        ThinSgSimulation sim = new ThinSgSimulation(https);
        Object object = sims_LOCK;
        synchronized (object) {
            sims.add(sim);
        }
        simlaunch.runAsync((Runnable)sim);
    }

    static {
        isMonitoring = false;
        pkHashPortion = "";
        seen_LOCK = new Object();
        seen = new Cache("IgnoredSecMsgs", 1000);
        sims_LOCK = new Object();
        sims = new ArrayList();
        startup_LOCK = new Object();
        simlaunch = new OnDemandThreadPool("simlaunch", HANDSHAKE_THREADS, 1000000, 5);
    }

    static class ThinSgSimulation
    extends Thread
    implements SecureMessengerListener,
    LossyMessageHandler {
        String name = "Thin RA Service " + Math.abs(random.nextLong());
        LossyClient lossyClient;
        LossyTransport lossyTransport;
        SecureMessenger secmsg;
        long sgTransientId;
        SimpleGatewayID masterid;
        final HashMap<String, Long> timestamps = new HashMap();
        long httpMillisSleep = 5000L;
        boolean immediatePingNextTime = false;
        boolean ready = false;
        boolean https = false;
        String serverPollUrl;
        Socket socket;
        OutputStream out;
        InputStream in;

        public ThinSgSimulation(boolean https) {
            this.https = https;
            this.serverPollUrl = serverHttp;
            if (https) {
                if (this.serverPollUrl.toLowerCase().startsWith("http://")) {
                    this.serverPollUrl = "https" + this.serverPollUrl.substring(4);
                }
            } else if (this.serverPollUrl.toLowerCase().startsWith("https://")) {
                this.serverPollUrl = "http" + this.serverPollUrl.substring(5);
            }
        }

        public void runMaintenance() throws Exception {
            Message claim = SimpleGatewayService.testing_createMessage(1589706771, this.masterid);
            claim.append(this.sgTransientId);
            Message msettings = new Message(1589706759);
            msettings.append(isMonitoring);
            msettings.append(true);
            msettings.append(true);
            claim.append(msettings);
            if (VERBOSE_CLAIM) {
                System.out.println("[AccessLoad] Trying to claim ID");
            }
            if (this.secmsg == null) {
                System.out.println("[AccessLoad] ERROR trying to transact with null secmsg");
            }
            Message resp = this.secmsg.transactSecure(claim);
            LossyTransport transport = this.secmsg.getUnderlyingTransport();
            if (transport instanceof UdpClientLossyTransport) {
                ((UdpClientLossyTransport)transport).resetNonResponseCounter();
            }
            if (resp != null) {
                int type = resp.getType();
                if (type == 1589706755) {
                    if (VERBOSE_CLAIM) {
                        System.out.println("[AccessLoad] OK");
                    }
                } else {
                    System.out.println("[AccessLoad] Errr..." + type + " / " + resp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.sgTransientId = random.nextLong();
                String mysecmsgid = "testSecMsg" + Math.abs(random.nextLong());
                this.masterid = new SimpleGatewayID();
                this.masterid.resetToFakeID();
                System.out.println(this.name + " / " + this.masterid.getID() + " / " + mysecmsgid + " / " + this.sgTransientId);
                this.lossyClient = new LossyClient();
                this.lossyClient.init(this, BCUtil.getSecureRandom());
                this.lossyTransport = new HttpClientLossyTransport(this.serverPollUrl, this.masterid.getID());
                BCUtil bcu = new BCUtil();
                bcu.setValidHashRequired(false);
                this.doPollThreadInitial();
                Object object = handshake_LOCK;
                synchronized (object) {
                    while (true) {
                        try {
                            this.secmsg = SecureMessenger.createSecureMessengerAsClient(bcu, this.lossyClient, this.lossyTransport, mysecmsgid, this, this.masterid.getID());
                        }
                        catch (Exception xx) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        break;
                    }
                }
                this.runMaintenance();
                System.out.println("ThinSg ready, exiting");
                this.ready = true;
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public Message getPingMessage() {
            Message message = new Message(55430000);
            message.append(this.masterid.getID());
            message.append("2");
            message.append("5.1");
            message.append(false);
            message.append(System.currentTimeMillis());
            message.append(Version.getSsuiteFullBuildVersion());
            message.append(pkHashPortion);
            byte state = 0;
            message.append(state);
            return message;
        }

        public void doPollThreadInitial() throws IOException {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.connect(new InetSocketAddress(serverHost, serverPort));
            this.socket = WorkingNioSocket.fixNIO(socketChannel.socket());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.doPollThreadQuery();
        }

        public void doPollThreadQuery() {
            Message pingMessage = this.getPingMessage();
            String hexPingMessage = HexData.byteArrayToHexString((byte[])MessageUtils.messageToBytes((Message)pingMessage));
            try {
                this.out.write(("GET /machine-" + System.currentTimeMillis() + "?ping=" + hexPingMessage + " HTTP/1.1\n").getBytes());
                this.out.write("\n".getBytes());
                this.out.flush();
                this.httpMillisSleep = 5000L;
                pollSelect.dumpIntoPool(this.socket, this);
            }
            catch (IOException x) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Thread.sleep(10000L);
                    this.doPollThreadInitial();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void doPollThreadResponse() {
            try {
                int contentLen = -1;
                String line = StreamUtils.readLine(this.in);
                while (line.length() > 0) {
                    if ((line = line.toLowerCase().trim()).startsWith("content-length")) {
                        line = line.substring(line.indexOf(58) + 1).trim();
                        contentLen = Integer.parseInt(line);
                    }
                    line = StreamUtils.readLine(this.in);
                }
                if (contentLen > 0) {
                    byte[] buf = new byte[contentLen];
                    new DataInputStream(this.in).readFully(buf);
                    this.handleMessage(buf, null, null, null);
                }
                this.doPollThreadQuery();
            }
            catch (IOException x) {
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Thread.sleep(10000L);
                    this.doPollThreadInitial();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
            Message msg;
            Message m = MessageUtils.bytesToMessage((byte[])dat);
            if (m.getType() == 3002000) {
                Message lossy = (Message)m.pop();
                this.lossyClient.lossyMessageReceived(this.lossyTransport, lossy, null);
                return;
            }
            Object peek = m.peek();
            if (peek instanceof Message && (msg = (Message)m.pop()).getType() == 3005000) {
                for (int i = 0; i < msg.length(); ++i) {
                    Message sub = (Message)msg.get(i);
                    if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                        System.out.println("[SecmsgInitial] Incoming message from ping-return " + sub);
                    }
                    this.lossyClient.lossyMessageReceived(this.lossyTransport, sub, null);
                }
            }
            int index = 0;
            long timestamp = m.getAsLong(index++);
            m.getAsString(index++);
            String messagingThreadKey = "" + m.getType();
            Long latestMessageReceived = this.timestamps.get(messagingThreadKey);
            if (latestMessageReceived == null) {
                latestMessageReceived = new Long(-99L);
            }
            if (timestamp <= latestMessageReceived) {
                return;
            }
            this.timestamps.put(messagingThreadKey, new Long(timestamp));
            switch (m.getType()) {
                case 55430002: {
                    System.out.println("[AccessLoad] [SecMsg] Unable to process SG_UDP_PINGME");
                    break;
                }
                case 55430008: {
                    System.out.println("[AccessLoad] [SecMsg] Unable to process SG_UDP_SEND_SERVER_VERSION");
                    break;
                }
                case 55430001: {
                    System.out.println("[AccessLoad] [SecMsg] Unable to process SG_CONNECT");
                    break;
                }
                case 55430007: {
                    System.out.println("[AccessLoad] [SecMsg] Unable to process SG_SEND_LOGS");
                    break;
                }
                case 55430006: {
                    this.httpMillisSleep = m.getAsLong(index++);
                    break;
                }
                case 55430009: {
                    long ignoredHttpMillisSleep = m.getAsLong(index++);
                    this.immediatePingNextTime = true;
                    break;
                }
                default: {
                    System.out.println("[PollThread] WARNING: Unknown message of type (" + m.getType() + ")");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void incomingSecureMessage(SecureMessenger incomingSecmsg, String messengerID, Message message, Long respondConv, Object source) {
            int type;
            SecureMessenger secresp = SecureMessengerDB.fetchSecureMessenger(messengerID);
            if (secresp != incomingSecmsg) {
                System.out.println("***WARNING responding secmsg is not same as incoming for " + messengerID);
            }
            if ((type = message.getType()) == 1589706756) {
                Message m = SimpleGatewayService.testing_createMessage(1589706757, this.masterid);
                m.append(this.name);
                m.append(Version.getSsuiteFullBuildVersion());
                m.append(accessVersion);
                secresp.secureSendNoBlock(m);
            } else if (type == 1589706777) {
                boolean fullList = message.getNextBoolean();
                long alertsModClock = message.getNextLong();
                long alertsHash = message.getNextLong();
                Message reserved = message.getNextMessage();
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Received update from " + messengerID + ": fullList=" + fullList + ", serverAlertModClock=" + alertsModClock + ", fullHash=" + alertsHash + " msgLen=" + message.length());
                }
                Message clock = SimpleGatewayService.testing_createMessage(1589706778, this.masterid);
                clock.append(alertsModClock);
                clock.append(alertsHash);
                secresp.secureSendNoBlock(clock, respondConv);
            } else {
                Object object = seen_LOCK;
                synchronized (object) {
                    if (seen.getFromCache((Object)message.getType()) == null) {
                        System.out.println("[AccessLoad] Ignored secmsg: " + message.toString(PC.REFS));
                        seen.addToCache((Object)message.getType(), (Object)message.getType());
                    }
                }
            }
        }

        @Override
        public void handleAsyncMessage(byte[] data, LossyTransport respond, Long respondConversation, Object source) {
            Message m = MessageUtils.bytesToMessage((byte[])data);
            if (VERBOSE_LOSSY) {
                System.out.println("[AccessLoad] Incoming lossy message: " + m);
            }
            if (m == null) {
                System.out.println("Dropped invalid message from " + respond.getUnderlyingProtocolDescription() + "/" + respondConversation);
                return;
            }
            int type = m.getType();
            if (!LossyUtils.isCurrentProtocol(type)) {
                return;
            }
            if (type != 274596355) {
                if (type == 274596444 || type == 274596432) {
                    try {
                        SecureMessenger.handleIncomingSecureMessage(data, respond, respondConversation, false, this);
                    }
                    catch (SecMsgDecryptionError x) {
                        System.out.println("[AccessLoad] [SecMsg] Unable to process incoming message - " + x.getMessage());
                        System.out.println("[AccessLoad] [SecMsg] unable to renegotiate as required");
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                } else if (type == 274596505) {
                    System.out.println("[AccessLoad] [SecMsg] unable to renegotiate as asked");
                } else if (type == 3003000) {
                    System.out.println("[LossyMessageTest] Message " + m + ", appending and echoing");
                    m.setType(m.getType() + 1);
                    m.append("(machine response)");
                    this.lossyClient.sendLossy(respond, MessageUtils.messageToBytes((Message)m), respondConversation);
                } else if (type == 3006000) {
                    if (Math.random() < 0.5) {
                        System.out.println("[LossyMessageTest] G-Message " + m + ", dropping");
                    } else {
                        System.out.println("[LossyMessageTest] G-Message " + m + ", appending and echoing");
                    }
                    m.setType(m.getType() + 1);
                    m.append("(machine response)");
                    this.lossyClient.sendGuaranteed(respond, MessageUtils.messageToBytes((Message)m), respondConversation);
                } else {
                    System.out.println("[AccessLoad] [SecMsg] Ignoring lossy message request " + m);
                }
            }
        }
    }

    static class PollHandler
    implements SelectPoolHandler {
        PollHandler() {
        }

        @Override
        public void process(Socket socket, Object attachment) {
            ThinSgSimulation pollThread = (ThinSgSimulation)attachment;
            pollThread.doPollThreadResponse();
        }
    }

    static class MaintenanceRunner
    extends Thread {
        MaintenanceRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                System.out.println("[AccessLoad] Running claims, monitoring messages etc in 20s...");
                try {
                    Thread.sleep(20000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = sims_LOCK;
                synchronized (object) {
                    for (ThinSgSimulation sim : sims) {
                        try {
                            if (!sim.ready) continue;
                            sim.runMaintenance();
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

