/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.notifications;

import com.aem.sdesktop.common.CachedSplashLoader;
import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import utils.ostools.OS;
import utils.swing.JTextLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;

public class StandaloneNotification
extends JFrame {
    private static final int WIDTH = 440;
    private JFrame frame;
    private JButton dismiss;
    private static final int spacer = SimpleHelpLookAndFeel.scale((int)10);

    public StandaloneNotification(Image icon, String title, String message, ActionListener listener) {
        try {
            SimpleHelpFrame.getTestFrame();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.frame = this;
        title = title.trim();
        message = message.trim();
        icon = icon == null ? CachedSplashLoader.getSplashFromCache(SimpleHelpLookAndFeel.scale((int)440), SimpleHelpLookAndFeel.scale((int)96)) : ImageHelper.scaleDownToFitInside((BufferedImage)ImageHelper.toBufferedImageARGB((Image)icon), (int)SimpleHelpLookAndFeel.scale((int)440), (int)SimpleHelpLookAndFeel.scale((int)96));
        BorderPanel nomargin = new BorderPanel((Insets)new ScaledInsets(0, 0, 0, 0));
        BorderPanel upper = new BorderPanel((Insets)new ScaledInsets(0, 0, 0, 0));
        nomargin.addNorth((JComponent)upper);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setOpaque(true);
        titleLabel.setFont(SHStyle.largeFont);
        titleLabel.setBorder(SHBorderFactory.createEmptyBorder((int)7, (int)7, (int)7, (int)7));
        titleLabel.setHorizontalAlignment(0);
        upper.addSouth((JComponent)titleLabel);
        titleLabel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        BorderPanel bp = new BorderPanel((Insets)new ScaledInsets(7, 7, 7, 7));
        bp.setBackground(SHStyle.PANEL_BACKGROUND_LIGHT);
        nomargin.addCenter((JComponent)bp);
        JLabel iconLabel = new JLabel(new ImageIcon(icon));
        iconLabel.setVerticalAlignment(1);
        iconLabel.setHorizontalAlignment(0);
        upper.addCenter((JComponent)iconLabel);
        iconLabel.setBorder(SHBorderFactory.createEmptyBorder((int)7, (int)7, (int)7, (int)7));
        this.dismiss = new JButton(Language.get("DISMISS"));
        this.dismiss.setMargin((Insets)new ScaledInsets(7, 10, 7, 10));
        GbPanel panel = new GbPanel();
        panel.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2));
        panel.add((Component)this.dismiss, 0, 0, 1, 1, 1, 1, 10, 0);
        bp.addSouth((JComponent)panel);
        JTextLabel label = new JTextLabel(message);
        label.fixSizeByWidth(SimpleHelpLookAndFeel.scale((int)440));
        label.setWrapStyleWord(true);
        bp.addCenter((JComponent)label);
        this.frame.getContentPane().add((Component)nomargin);
        this.dismiss.addActionListener(listener);
        this.frame.setUndecorated(true);
        this.frame.setDefaultCloseOperation(0);
        this.frame.setResizable(false);
        this.setAlwaysOnTop(this.frame, true);
        this.frame.setFocusableWindowState(false);
        this.frame.setFocusable(false);
        this.frame.pack();
        label.setPreferredSize(null);
        Toolkit toolkit = this.frame.getToolkit();
        Insets insets = toolkit.getScreenInsets(this.frame.getGraphicsConfiguration());
        Dimension frameSize = this.frame.getSize();
        Dimension size = toolkit.getScreenSize();
        if (OS.isWindows()) {
            this.frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right - spacer, size.height - (int)frameSize.getHeight() - insets.bottom - spacer);
        } else {
            this.frame.setLocation(size.width - (int)frameSize.getWidth() - insets.left - insets.right - spacer, insets.top + spacer);
        }
        this.frame.setVisible(true);
    }

    private void setAlwaysOnTop(JFrame frame, boolean b) {
        try {
            Method method = frame.getClass().getMethod("setAlwaysOnTop", Boolean.TYPE);
            method.invoke((Object)frame, new Boolean(b));
        }
        catch (Throwable t) {
            System.out.println("Frame notification not always on top - pre 1.5 JVM");
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        new StandaloneNotification(ImageIO.read(new File("/Users/gchristelis/Desktop/sh_large.png")), "Message to Users", "Dear User,\n\nCould everyone please take note to clean all coffee mugs before going home at night.\n\nThank you\n\nYour Friendly SysAdmin", new QuitActionListener());
    }

    static class QuitActionListener
    implements ActionListener {
        QuitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }
}

