/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.utils.NativeUtils;
import jwrapper.hidden.JWNativeAPI;

public class WReg {
    public static final String REG_SZ = "REG_SZ";
    public static final String REG_EXPAND_SZ = "REG_EXPAND_SZ";
    public static final String REG_DWORD = "REG_DWORD";
    public static final String REG_QWORD = "REG_QWORD";

    private static void debug_traverse(String parent, int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(" ");
        }
        System.out.println(" -> " + parent);
        System.out.flush();
        String[][] children = WReg.getChildren(parent);
        if (children.length > 0) {
            for (int i = 0; i < children[0].length; ++i) {
                WReg.debug_traverse(parent + "\\" + children[0][i], indent + 1);
            }
        }
    }

    private static String getRootKeyName(String keyName) {
        int firstSlash = keyName.indexOf(92);
        if (firstSlash == -1) {
            return keyName;
        }
        return keyName.substring(0, firstSlash);
    }

    private static String getSubKeyName(String keyName) {
        int firstSlash = keyName.indexOf(92);
        if (firstSlash == -1) {
            return "";
        }
        return keyName.substring(firstSlash + 1);
    }

    private static String getParentOfLastKey(String keyName) {
        int firstSlash = keyName.indexOf(92);
        int lastSlash = keyName.lastIndexOf(92);
        if (firstSlash == -1) {
            return "";
        }
        return keyName.substring(0, lastSlash).substring(firstSlash + 1);
    }

    private static String getLastKeyName(String keyName) {
        int lastSlash = keyName.lastIndexOf(92);
        if (lastSlash == -1) {
            return "";
        }
        return keyName.substring(lastSlash + 1);
    }

    public static void deleteValue(String keyName, String valueName) {
        if (CentralDebugging.DEBUG_WREG) {
            System.out.println("[WReg] Deleting value " + keyName + "!" + valueName);
        }
        if (NativeUtils.getInstance() != null) {
            JWNativeAPI.getInstance().regDeleteValue(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName), valueName);
        }
    }

    public static boolean deleteKey(String keyName) {
        if (CentralDebugging.DEBUG_WREG) {
            System.out.println("[WReg] Deleting key " + keyName);
        }
        if (NativeUtils.getInstance() != null) {
            String rootKey = WReg.getRootKeyName(keyName);
            String keyNameToDelete = WReg.getLastKeyName(keyName);
            String parentKey = WReg.getParentOfLastKey(keyName);
            return JWNativeAPI.getInstance().regDeleteKey(rootKey, parentKey, keyNameToDelete);
        }
        return false;
    }

    public static boolean set(String keyName, String valueName, String valueValue, String type) {
        if (NativeUtils.getInstance() != null) {
            if (CentralDebugging.DEBUG_WREG) {
                System.out.println("[WReg] Setting " + keyName + "!" + valueName + " to " + valueValue);
            }
            JWNativeAPI.getInstance().regSet(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName), valueName, valueValue, type);
            String queried = WReg.get(keyName, valueName);
            if (CentralDebugging.DEBUG_WREG) {
                System.out.println("[WReg] Verifying. Read " + queried);
            }
            if (!WReg.checkEquality(queried, valueValue)) {
                System.out.println("[WReg] Setting " + keyName + "!" + valueName + " to " + valueValue + " failed. Returned " + queried + " instead.");
                return false;
            }
            if (CentralDebugging.DEBUG_WREG) {
                System.out.println("[WReg] Set was successful.");
            }
            return true;
        }
        return true;
    }

    private static boolean checkEquality(String queried, String valueValue) {
        if (queried.equals(valueValue)) {
            return true;
        }
        try {
            return Integer.toString(WReg.dwordHexToInt(queried)).equals(valueValue);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean createRegistryKey(String keyName) {
        if (CentralDebugging.DEBUG_WREG) {
            System.out.println("[WReg] Creating key " + keyName);
        }
        if (NativeUtils.getInstance() != null) {
            return JWNativeAPI.getInstance().regCreateKey(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName));
        }
        return false;
    }

    public static boolean keyExists(String keyName) {
        if (CentralDebugging.DEBUG_WREG) {
            System.out.println("[WReg] Checking if key exists: " + keyName);
        }
        if (NativeUtils.getInstance() != null) {
            String[] result = JWNativeAPI.getInstance().regGetChildren(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName));
            return result != null;
        }
        return false;
    }

    public static String[][] getChildren(String keyName) {
        if (CentralDebugging.DEBUG_WREG) {
            System.out.println("[WReg] Getting children of " + keyName);
        }
        if (NativeUtils.getInstance() != null) {
            String[] result = JWNativeAPI.getInstance().regGetChildren(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName));
            if (result == null) {
                return new String[0][0];
            }
            int numberOfKeys = 0;
            int numberOfValues = 0;
            for (String aResult : result) {
                if (aResult.startsWith("------")) break;
                ++numberOfKeys;
            }
            numberOfValues = result.length - numberOfKeys - 1;
            String[] keys = new String[numberOfKeys];
            String[] values = new String[numberOfValues];
            System.arraycopy(result, 0, keys, 0, numberOfKeys);
            System.arraycopy(result, numberOfKeys + 1, values, 0, numberOfValues);
            return new String[][]{keys, values};
        }
        return new String[0][0];
    }

    public static String getOrNull(String keyName, String valueName) {
        if (NativeUtils.getInstance() != null) {
            if (CentralDebugging.DEBUG_WREG) {
                System.out.println("[WReg] Querying " + keyName + "!" + valueName);
            }
            String ret = JWNativeAPI.getInstance().regGet(WReg.getRootKeyName(keyName), WReg.getSubKeyName(keyName), valueName);
            if (CentralDebugging.DEBUG_WREG) {
                System.out.println("[WReg] Got " + ret);
            }
            if (ret == null) {
                System.out.println("[WReg] Key " + keyName + ", value " + valueName + " was empty...\n\n\n\n");
                return null;
            }
            return ret;
        }
        return null;
    }

    public static String get(String keyName, String valueName, String typeNotUsed) {
        return WReg.get(keyName, valueName);
    }

    public static String get(String keyName, String valueName) {
        String result = WReg.getOrNull(keyName, valueName);
        if (result == null) {
            return "";
        }
        return result;
    }

    private static int dwordHexToInt(String dword) throws NumberFormatException {
        if (!(dword = dword.trim().toLowerCase()).startsWith("0x")) {
            throw new NumberFormatException("[WReg] unable to parse hex value: " + dword);
        }
        dword = dword.substring(2);
        return Integer.parseInt(dword, 16);
    }
}

